/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.transientstore.api;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.transientstore.SimpleTransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreProvider;

@XObject(value="store")
public class TransientStoreConfig {
    @XNode(value="@name")
    protected String name;
    @XNode(value="@path")
    protected String path;
    @XNode(value="targetMaxSizeMB")
    protected int targetMaxSizeMB = -1;
    @XNode(value="absoluteMaxSizeMB")
    protected int absoluteMaxSizeMB = -1;
    @XNode(value="firstLevelTTL")
    protected int firstLevelTTL = 120;
    @XNode(value="secondLevelTTL")
    protected int secondLevelTTL = 10;
    @XNode(value="minimalRetention")
    protected int minimalRetention = 10;
    @XNode(value="@class")
    protected Class<? extends TransientStoreProvider> implClass = SimpleTransientStore.class;
    protected TransientStoreProvider store;
    @XNodeMap(value="property", key="@name", type=HashMap.class, componentType=String.class, nullByDefault=true)
    protected Map<String, String> properties;

    public TransientStoreConfig() {
    }

    public TransientStoreConfig(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getTargetMaxSizeMB() {
        return this.targetMaxSizeMB;
    }

    public void setTargetMaxSizeMB(int targetMaxSizeMB) {
        this.targetMaxSizeMB = targetMaxSizeMB;
    }

    public int getAbsoluteMaxSizeMB() {
        return this.absoluteMaxSizeMB;
    }

    public void setAbsoluteMaxSizeMB(int absoluteMaxSizeMB) {
        this.absoluteMaxSizeMB = absoluteMaxSizeMB;
    }

    public int getFirstLevelTTL() {
        return this.firstLevelTTL;
    }

    public void setFirstLevelTTL(int firstLevelTTL) {
        this.firstLevelTTL = firstLevelTTL;
    }

    public int getSecondLevelTTL() {
        return this.secondLevelTTL;
    }

    public void setSecondLevelTTL(int secondLevelTTL) {
        this.secondLevelTTL = secondLevelTTL;
    }

    public TransientStoreProvider getStore() {
        if (this.store == null) {
            try {
                this.store = this.implClass.newInstance();
                this.store.init(this);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
        return this.store;
    }

    public void flush() {
        this.store = null;
    }

    public String getDataDir() {
        return this.path;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

