/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.commons.io.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.runtime.api.Framework;

public class RTF2TextConverter
implements Converter {
    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        File f = null;
        try {
            Blob blob;
            RTFEditorKit rtfParser = new RTFEditorKit();
            Document document = rtfParser.createDefaultDocument();
            rtfParser.read(blobHolder.getBlob().getStream(), document, 0);
            String text = document.getText(0, document.getLength());
            f = Framework.createTempFile((String)"swing-rtf2text", (String)".txt");
            FileUtils.writeStringToFile((File)f, (String)text, (Charset)StandardCharsets.UTF_8);
            try (FileInputStream in = new FileInputStream(f);){
                blob = Blobs.createBlob((InputStream)in, (String)"text/plain");
            }
            SimpleCachableBlobHolder simpleCachableBlobHolder = new SimpleCachableBlobHolder(blob);
            return simpleCachableBlobHolder;
        }
        catch (IOException | BadLocationException e) {
            throw new ConversionException("Error during Word2Text conversion", (Throwable)e);
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

