/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.plugins.text.extractors.BaseOfficeXMLTextConverter;

public class XLX2TextConverter
extends BaseOfficeXMLTextConverter
implements Converter {
    private static final Log log = LogFactory.getLog(XLX2TextConverter.class);
    private static final String CELL_SEP = " ";
    private static final String ROW_SEP = "\n";

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        StringBuffer sb = new StringBuffer();
        try {
            Blob blob = blobHolder.getBlob();
            if (blob.getLength() > this.maxSize4POI) {
                return this.runFallBackConverter(blobHolder, "xl/");
            }
            try (InputStream stream = blob.getStream();
                 OPCPackage p = OPCPackage.open((InputStream)stream);
                 XSSFWorkbook workbook = new XSSFWorkbook(p);){
                for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                    XSSFSheet sheet = workbook.getSheetAt(i);
                    Iterator rows = sheet.rowIterator();
                    while (rows.hasNext()) {
                        XSSFRow row = (XSSFRow)rows.next();
                        Iterator cells = row.cellIterator();
                        while (cells.hasNext()) {
                            XSSFCell cell = (XSSFCell)cells.next();
                            this.appendTextFromCell(cell, sb);
                        }
                        sb.append(ROW_SEP);
                    }
                }
            }
            return new SimpleCachableBlobHolder(Blobs.createBlob((String)sb.toString()));
        }
        catch (IOException | OpenXML4JException e) {
            throw new ConversionException("Error during XLX2Text conversion", e);
        }
    }

    protected void appendTextFromCell(XSSFCell cell, StringBuffer sb) {
        String cellValue = null;
        switch (cell.getCellType()) {
            case 0: {
                cellValue = Double.toString(cell.getNumericCellValue()).trim();
                break;
            }
            case 1: {
                cellValue = cell.getStringCellValue().trim();
            }
        }
        if (cellValue != null && cellValue.length() > 0) {
            sb.append(cellValue).append(CELL_SEP);
        }
    }
}

