/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.plugins;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.convert.plugins.CommandLineBasedConverter;
import org.nuxeo.runtime.api.Framework;

public class CommandLineConverter
extends CommandLineBasedConverter {
    public static final String SOURCE_FILE_PATH_KEY = "sourceFilePath";
    public static final String OUT_DIR_PATH_KEY = "outDirPath";
    public static final String TARGET_FILE_NAME_KEY = "targetFileName";
    public static final String TARGET_FILE_PATH_KEY = "targetFilePath";
    public static final List<String> RESERVED_PARAMETERS = Arrays.asList("sourceFilePath", "outDirPath", "targetFilePath", "CommandLineName");

    @Override
    protected Map<String, Blob> getCmdBlobParameters(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        HashMap<String, Blob> cmdBlobParams = new HashMap<String, Blob>();
        cmdBlobParams.put(SOURCE_FILE_PATH_KEY, blobHolder.getBlob());
        return cmdBlobParams;
    }

    @Override
    protected Map<String, String> getCmdStringParameters(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        String tmpDir = this.getTmpDirectory(parameters);
        Path tmpDirPath = tmpDir != null ? Paths.get(tmpDir, new String[0]) : null;
        try {
            Path outDirPath = tmpDirPath != null ? Files.createTempDirectory(tmpDirPath, null, new FileAttribute[0]) : Framework.createTempDirectory(null, (FileAttribute[])new FileAttribute[0]);
            HashMap<String, String> cmdStringParams = new HashMap<String, String>();
            cmdStringParams.put(OUT_DIR_PATH_KEY, outDirPath.toString());
            String targetFileName = (String)((Object)parameters.get(TARGET_FILE_NAME_KEY));
            Path targetFilePath = targetFileName == null ? Files.createTempFile(outDirPath, null, null, new FileAttribute[0]) : Paths.get(outDirPath.toString(), targetFileName);
            cmdStringParams.put(TARGET_FILE_PATH_KEY, targetFilePath.toString());
            if (targetFileName == null) {
                Files.delete(targetFilePath);
            }
            for (Map.Entry<String, Serializable> entry : parameters.entrySet()) {
                if (RESERVED_PARAMETERS.contains(entry.getKey())) continue;
                cmdStringParams.put(entry.getKey(), (String)((Object)entry.getValue()));
            }
            for (Map.Entry<String, Serializable> entry : this.initParameters.entrySet()) {
                if (RESERVED_PARAMETERS.contains(entry.getKey())) continue;
                cmdStringParams.put(entry.getKey(), (String)((Object)entry.getValue()));
            }
            return cmdStringParams;
        }
        catch (IOException e) {
            throw new ConversionException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected BlobHolder buildResult(List<String> cmdOutput, CmdParameters cmdParams) throws ConversionException {
        File[] files;
        String outputPath = cmdParams.getParameter(OUT_DIR_PATH_KEY);
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        File outputDir = new File(outputPath);
        if (outputDir.exists() && outputDir.isDirectory() && (files = outputDir.listFiles()) != null) {
            for (File file : files) {
                try {
                    Blob blob = Blobs.createBlob((File)file);
                    blob.setFilename(file.getName());
                    blobs.add(blob);
                }
                catch (IOException e) {
                    throw new ConversionException("Cannot create blob", (Throwable)e);
                }
            }
        }
        return new SimpleCachableBlobHolder(blobs);
    }
}

