/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.filter;

import com.google.common.base.CharMatcher;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ArrayProperty;
import org.nuxeo.ecm.core.api.model.impl.ComplexProperty;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.StringProperty;
import org.nuxeo.ecm.core.filter.CharacterFilteringService;
import org.nuxeo.ecm.core.filter.CharacterFilteringServiceDescriptor;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class CharacterFilteringServiceImpl
extends DefaultComponent
implements CharacterFilteringService {
    public static final String FILTERING_XP = "filtering";
    protected CharacterFilteringServiceDescriptor desc;
    protected CharMatcher charsToRemove;

    public void registerContribution(Object contrib, String point, ComponentInstance contributor) {
        if (FILTERING_XP.equals(point)) {
            this.desc = (CharacterFilteringServiceDescriptor)contrib;
            CharMatcher charsToPreserve = CharMatcher.anyOf((CharSequence)"\r\n\t");
            CharMatcher allButPreserved = charsToPreserve.negate();
            this.charsToRemove = CharMatcher.JAVA_ISO_CONTROL.and(allButPreserved);
            this.charsToRemove = this.charsToRemove.or(CharMatcher.INVISIBLE.and(CharMatcher.WHITESPACE.negate()));
            List<String> additionalChars = this.desc.getDisallowedChars();
            if (additionalChars != null && !additionalChars.isEmpty()) {
                String otherCharsToRemove = additionalChars.stream().map(StringEscapeUtils::unescapeJava).collect(Collectors.joining());
                this.charsToRemove = this.charsToRemove.or(CharMatcher.anyOf((CharSequence)otherCharsToRemove));
            }
        } else {
            throw new RuntimeException("Unknown extension point: " + point);
        }
    }

    @Override
    public String filter(String value) {
        return this.charsToRemove.removeFrom((CharSequence)value);
    }

    @Override
    public void filter(DocumentModel docModel) {
        if (this.desc.isEnabled()) {
            for (DataModel dm : docModel.getDataModelsCollection()) {
                if (!dm.isDirty()) continue;
                DocumentPart part = ((DataModelImpl)dm).getDocumentPart();
                for (Property prop : part.getChildren()) {
                    this.filterProperty(prop, docModel);
                }
            }
        }
    }

    private void filterProperty(Property prop, DocumentModel docModel) {
        block9: {
            block10: {
                block8: {
                    if (!prop.isDirty()) {
                        return;
                    }
                    if (!(prop instanceof StringProperty)) break block8;
                    String p = (String)((Object)prop.getValue());
                    if (p == null || !this.charsToRemove.matchesAnyOf((CharSequence)p)) break block9;
                    String filteredProp = this.filter(p);
                    docModel.setPropertyValue(prop.getXPath(), (Serializable)((Object)filteredProp));
                    break block9;
                }
                if (!(prop instanceof ArrayProperty)) break block10;
                Serializable value = prop.getValue();
                if (!(value instanceof Object[])) break block9;
                Object[] arrayProp = (Object[])value;
                boolean modified = false;
                for (int i = 0; i < arrayProp.length; ++i) {
                    String p;
                    if (!(arrayProp[i] instanceof String) || !this.charsToRemove.matchesAnyOf((CharSequence)(p = (String)arrayProp[i]))) continue;
                    arrayProp[i] = this.filter(p);
                    modified = true;
                }
                if (modified) {
                    docModel.setPropertyValue(prop.getXPath(), (Serializable)arrayProp);
                }
                break block9;
            }
            if (prop instanceof ComplexProperty) {
                ComplexProperty complexProp = (ComplexProperty)prop;
                for (Property subProp : complexProp.getChildren()) {
                    this.filterProperty(subProp, docModel);
                }
            } else if (prop instanceof ListProperty) {
                ListProperty listProp = (ListProperty)prop;
                for (Property p : listProp) {
                    this.filterProperty(p, docModel);
                }
            }
        }
    }
}

