/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.local.LocalException;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolver;

public class DocumentModelResolver
implements ObjectResolver {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_REPO_NAME = "default";
    public static final String NAME = "documentResolver";
    public static final String PARAM_STORE = "store";
    public static final String STORE_PATH_REF = "path";
    public static final String STORE_ID_REF = "id";
    private Map<String, Serializable> parameters;
    private MODE mode = MODE.ID_REF;
    private List<Class<?>> managedClasses = null;

    public MODE getMode() {
        return this.mode;
    }

    public List<Class<?>> getManagedClasses() {
        if (this.managedClasses == null) {
            this.managedClasses = new ArrayList();
            this.managedClasses.add(DocumentModel.class);
        }
        return this.managedClasses;
    }

    public void configure(Map<String, String> parameters) throws IllegalStateException {
        if (this.parameters != null) {
            throw new IllegalStateException("cannot change configuration, may be already in use somewhere");
        }
        String store = parameters.get(PARAM_STORE);
        if (store != null) {
            if (STORE_ID_REF.equals(store)) {
                this.mode = MODE.ID_REF;
            } else if (STORE_PATH_REF.equals(store)) {
                this.mode = MODE.PATH_REF;
            }
        }
        this.parameters = new HashMap<String, Serializable>();
        this.parameters.put(PARAM_STORE, (Serializable)((Object)(this.mode == MODE.ID_REF ? STORE_ID_REF : STORE_PATH_REF)));
    }

    public String getName() {
        this.checkConfig();
        return NAME;
    }

    public Map<String, Serializable> getParameters() {
        this.checkConfig();
        return Collections.unmodifiableMap(this.parameters);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validate(Object value) throws IllegalStateException {
        this.checkConfig();
        if (value == null) return false;
        if (!(value instanceof String)) return false;
        REF ref = REF.fromValue((String)value);
        if (ref == null) return false;
        try (CloseableCoreSession session = CoreInstance.openCoreSession((String)ref.repo);){
            switch (this.mode) {
                case ID_REF: {
                    boolean bl = session.exists((DocumentRef)new IdRef(ref.ref));
                    return bl;
                }
                case PATH_REF: {
                    boolean bl = session.exists((DocumentRef)new PathRef(ref.ref));
                    return bl;
                }
            }
            return false;
        }
        catch (LocalException le) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object fetch(Object value) throws IllegalStateException {
        this.checkConfig();
        if (value == null) return null;
        if (!(value instanceof String)) return null;
        REF ref = REF.fromValue((String)value);
        if (ref == null) return null;
        try {
            Throwable throwable = null;
            try (CloseableCoreSession session = CoreInstance.openCoreSession((String)ref.repo);){
                DocumentModel doc;
                switch (this.mode) {
                    case ID_REF: {
                        doc = session.getDocument((DocumentRef)new IdRef(ref.ref));
                        break;
                    }
                    case PATH_REF: {
                        doc = session.getDocument((DocumentRef)new PathRef(ref.ref));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                doc.detach(true);
                DocumentModel documentModel = doc;
                return documentModel;
            }
            catch (DocumentNotFoundException e) {
                Object var6_10 = null;
                return var6_10;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (LocalException le) {
            return null;
        }
    }

    public <T> T fetch(Class<T> type, Object value) throws IllegalStateException {
        this.checkConfig();
        DocumentModel doc = (DocumentModel)this.fetch(value);
        if (doc != null) {
            if (type.isInstance(doc)) {
                return type.cast(doc);
            }
            return (T)doc.getAdapter(type);
        }
        return null;
    }

    public Serializable getReference(Object entity) throws IllegalStateException {
        DocumentModel doc;
        String repositoryName;
        this.checkConfig();
        if (entity != null && entity instanceof DocumentModel && (repositoryName = (doc = (DocumentModel)entity).getRepositoryName()) != null) {
            switch (this.mode) {
                case ID_REF: {
                    return repositoryName + ":" + doc.getId();
                }
                case PATH_REF: {
                    return repositoryName + ":" + doc.getPath().toString();
                }
            }
        }
        return null;
    }

    public String getConstraintErrorMessage(Object invalidValue, Locale locale) {
        this.checkConfig();
        switch (this.mode) {
            case ID_REF: {
                return ObjectResolver.Helper.getConstraintErrorMessage((ObjectResolver)this, (String)STORE_ID_REF, (Object)invalidValue, (Locale)locale, (String[])new String[0]);
            }
            case PATH_REF: {
                return ObjectResolver.Helper.getConstraintErrorMessage((ObjectResolver)this, (String)STORE_PATH_REF, (Object)invalidValue, (Locale)locale, (String[])new String[0]);
            }
        }
        return String.format("%s cannot resolve reference %s", this.getName(), invalidValue);
    }

    private void checkConfig() throws IllegalStateException {
        if (this.parameters == null) {
            throw new IllegalStateException("you should call #configure(Map<String, String>) before. Please get this resolver throught ExternalReferenceService which is in charge of resolver configuration.");
        }
    }

    protected static final class REF {
        protected String repo;
        protected String ref;

        protected REF() {
        }

        protected static REF fromValue(String value) {
            String[] split = value.split(":");
            if (split.length == 1) {
                REF ref = new REF();
                ref.repo = DocumentModelResolver.DEFAULT_REPO_NAME;
                ref.ref = split[0];
                return ref;
            }
            if (split.length == 2) {
                REF ref = new REF();
                ref.repo = split[0];
                ref.ref = split[1];
                return ref;
            }
            return null;
        }
    }

    public static enum MODE {
        PATH_REF,
        ID_REF;

    }
}

