/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.security.SecurityPolicy;
import org.nuxeo.ecm.core.security.SecurityPolicyDescriptor;
import org.nuxeo.ecm.core.security.SecurityPolicyService;

public class SecurityPolicyServiceImpl
implements SecurityPolicyService {
    private static final long serialVersionUID = 482814921906794786L;
    private static final Log log = LogFactory.getLog(SecurityPolicyServiceImpl.class);
    private final Map<String, SecurityPolicyDescriptor> policyDescriptors = new Hashtable<String, SecurityPolicyDescriptor>();
    private List<SecurityPolicy> policies;

    private void computePolicies() {
        this.policies = new ArrayList<SecurityPolicy>();
        ArrayList<SecurityPolicyDescriptor> orderedDescriptors = new ArrayList<SecurityPolicyDescriptor>();
        for (SecurityPolicyDescriptor descriptor : this.policyDescriptors.values()) {
            if (!descriptor.isEnabled()) continue;
            orderedDescriptors.add(descriptor);
        }
        Collections.sort(orderedDescriptors);
        ArrayList<String> policyNames = new ArrayList<String>();
        for (SecurityPolicyDescriptor descriptor : orderedDescriptors) {
            if (!descriptor.isEnabled()) continue;
            try {
                Object policy = descriptor.getPolicy().newInstance();
                if (policy instanceof SecurityPolicy) {
                    this.policies.add((SecurityPolicy)policy);
                    policyNames.add(descriptor.getName());
                    continue;
                }
                log.error((Object)String.format("Invalid contribution to security policy service %s: must implement SecurityPolicy interface", descriptor.getName()));
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        log.debug((Object)("Ordered security policies: " + ((Object)policyNames).toString()));
    }

    @Override
    public synchronized List<SecurityPolicy> getPolicies() {
        if (this.policies == null) {
            this.computePolicies();
        }
        return this.policies;
    }

    private void resetPolicies() {
        this.policies = null;
    }

    @Override
    public boolean arePoliciesRestrictingPermission(String permission) {
        for (SecurityPolicy policy : this.getPolicies()) {
            if (!policy.isRestrictingPermission(permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean arePoliciesExpressibleInQuery(String repositoryName) {
        for (SecurityPolicy policy : this.getPolicies()) {
            if (policy.isExpressibleInQuery(repositoryName)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<SQLQuery.Transformer> getPoliciesQueryTransformers(String repositoryName) {
        LinkedList<SQLQuery.Transformer> transformers = new LinkedList<SQLQuery.Transformer>();
        for (SecurityPolicy policy : this.getPolicies()) {
            if (policy.isExpressibleInQuery(repositoryName)) {
                transformers.add(policy.getQueryTransformer(repositoryName));
                continue;
            }
            log.warn((Object)String.format("Security policy '%s' for repository '%s' cannot be expressed in SQL query.", policy.getClass().getName(), repositoryName));
        }
        return transformers;
    }

    @Override
    public void registerDescriptor(SecurityPolicyDescriptor descriptor) {
        String id = descriptor.getName();
        if (this.policyDescriptors.containsKey(id)) {
            log.info((Object)("Overriding security policy " + id));
        }
        this.policyDescriptors.put(id, descriptor);
        this.resetPolicies();
    }

    @Override
    public void unregisterDescriptor(SecurityPolicyDescriptor descriptor) {
        String id = descriptor.getName();
        if (this.policyDescriptors.containsKey(id)) {
            this.policyDescriptors.remove(id);
            this.resetPolicies();
        }
    }

    @Override
    public Access checkPermission(Document doc, ACP mergedAcp, Principal principal, String permission, String[] resolvedPermissions, String[] additionalPrincipals) {
        Access access = Access.UNKNOWN;
        List<SecurityPolicy> policies = this.getPolicies();
        for (SecurityPolicy policy : policies) {
            Access policyAccess = policy.checkPermission(doc, mergedAcp, principal, permission, resolvedPermissions, additionalPrincipals);
            if (policyAccess == null || Access.UNKNOWN.equals(policyAccess)) continue;
            access = policyAccess;
            break;
        }
        return access;
    }
}

