/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.trash;

import java.io.Serializable;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.trash.TrashService;
import org.nuxeo.runtime.api.Framework;

public class BulkTrashedStateChangeListener
implements PostCommitFilteringEventListener {
    public static final String PROCESS_CHILDREN_KEY = "processChildrenForTrashedStageChange";
    private static final Log log = LogFactory.getLog(BulkTrashedStateChangeListener.class);

    public boolean acceptEvent(Event event) {
        EventContext ctx = event.getContext();
        return ctx instanceof DocumentEventContext && ((DocumentEventContext)ctx).getSourceDocument().isFolder() && Boolean.parseBoolean(String.valueOf(ctx.getProperty(PROCESS_CHILDREN_KEY)));
    }

    public void handleEvent(EventBundle events) {
        if (events.containsEventName("documentTrashed") || events.containsEventName("documentUntrashed")) {
            for (Event event : events) {
                if (!"documentTrashed".equals(event.getName()) && !"documentUntrashed".equals(event.getName())) continue;
                this.handleEvent(event);
            }
        }
    }

    protected void handleEvent(Event event) {
        log.debug((Object)"Processing trashed state change in async listener");
        DocumentEventContext ctx = (DocumentEventContext)event.getContext();
        DocumentModel doc = ctx.getSourceDocument();
        CoreSession session = ctx.getCoreSession();
        if (session == null) {
            log.error((Object)"Can not process trashed state change since session is null");
            return;
        }
        DocumentModelList children = session.getChildren(doc.getRef());
        TrashService trashService = (TrashService)Framework.getService(TrashService.class);
        Consumer<DocumentModel> trashOperation = "documentTrashed".equals(event.getName()) ? trashService::trashDocument : trashService::untrashDocument;
        for (DocumentModel child : children) {
            child.putContextData("skipTrashRenaming", (Serializable)Boolean.TRUE);
            trashOperation.accept(child);
        }
    }
}

