/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.trash;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.trash.TrashInfo;

public interface TrashService {
    public static final String DOCUMENT_TRASHED = "documentTrashed";
    public static final String DOCUMENT_UNTRASHED = "documentUntrashed";
    public static final String DISABLE_TRASH_RENAMING = "skipTrashRenaming";
    public static final String IS_ALREADY_CALLED = "trashServiceAlreadyCalled";

    public boolean isTrashed(CoreSession var1, DocumentRef var2);

    @Deprecated
    public boolean folderAllowsDelete(DocumentModel var1);

    @Deprecated
    public boolean checkDeletePermOnParents(List<DocumentModel> var1);

    @Deprecated
    public boolean canDelete(List<DocumentModel> var1, Principal var2, boolean var3);

    @Deprecated
    default public boolean canPurgeOrUndelete(List<DocumentModel> docs, Principal principal) {
        return this.canPurgeOrUntrash(docs, principal);
    }

    public boolean canPurgeOrUntrash(List<DocumentModel> var1, Principal var2);

    default public boolean canPurgeOrUntrash(DocumentModel doc, Principal principal) {
        return this.canPurgeOrUntrash(Collections.singletonList(doc), principal);
    }

    @Deprecated
    public TrashInfo getTrashInfo(List<DocumentModel> var1, Principal var2, boolean var3, boolean var4);

    @Deprecated
    public DocumentModel getAboveDocument(DocumentModel var1, Set<Path> var2);

    public DocumentModel getAboveDocument(DocumentModel var1, Principal var2);

    public void trashDocuments(List<DocumentModel> var1);

    default public void trashDocument(DocumentModel doc) {
        this.trashDocuments(Collections.singletonList(doc));
    }

    public void purgeDocuments(CoreSession var1, List<DocumentRef> var2);

    public void purgeDocumentsUnder(DocumentModel var1);

    @Deprecated
    public Set<DocumentRef> undeleteDocuments(List<DocumentModel> var1);

    default public void untrashDocuments(List<DocumentModel> docs) {
        this.undeleteDocuments(docs);
    }

    default public void untrashDocument(DocumentModel doc) {
        this.untrashDocuments(Collections.singletonList(doc));
    }

    public DocumentModelList getDocuments(DocumentModel var1);

    public String mangleName(DocumentModel var1);

    public String unmangleName(DocumentModel var1);

    public boolean hasFeature(Feature var1);

    public static enum Feature {
        TRASHED_STATE_IS_DEDICATED_PROPERTY;

    }
}

