/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.uidgen;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.uidgen.UIDGeneratorService;
import org.nuxeo.runtime.api.Framework;

public class DocUIDGeneratorListener
implements EventListener {
    private static final Log log = LogFactory.getLog(DocUIDGeneratorListener.class);

    public void handleEvent(Event event) {
        if (!"documentCreated".equals(event.getName())) {
            return;
        }
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            DocumentModel doc = docCtx.getSourceDocument();
            if (doc.isProxy() || doc.isVersion()) {
                return;
            }
            String eventId = event.getName();
            log.debug((Object)("eventId : " + eventId));
            try {
                DocUIDGeneratorListener.addUIDtoDoc(doc);
            }
            catch (PropertyNotFoundException e) {
                log.error((Object)("Error occurred while generating UID for doc: " + doc), (Throwable)e);
            }
        }
    }

    private static void addUIDtoDoc(DocumentModel doc) throws PropertyNotFoundException {
        UIDGeneratorService service = (UIDGeneratorService)Framework.getService(UIDGeneratorService.class);
        if (service == null) {
            log.error((Object)"<addUIDtoDoc> UIDGeneratorService service not found ... !");
            return;
        }
        service.setUID(doc);
    }
}

