/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.EOFException;
import java.io.ObjectInput;
import java.io.StreamCorruptedException;
import java.nio.BufferUnderflowException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.core.util.BooleanConsumer;
import net.openhft.chronicle.core.util.ObjBooleanConsumer;
import net.openhft.chronicle.core.util.ObjByteConsumer;
import net.openhft.chronicle.core.util.ObjFloatConsumer;
import net.openhft.chronicle.core.util.ObjShortConsumer;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.TriConsumer;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireObjectInput;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResultSetWireIn
implements WireIn {
    @NotNull
    private final ResultSet resultSet;
    private final ResultSetMetaData metaData;
    private final ValueIn valueIn = new RSValueIn();
    @Nullable
    private WireKey key;
    private int index = 0;
    private Object parent;

    public ResultSetWireIn(@NotNull ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        this.metaData = resultSet.getMetaData();
    }

    @Override
    public void clear() {
        this.key = null;
        this.index = 0;
    }

    @Override
    public void copyTo(@NotNull WireOut wire) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    @NotNull
    public ValueIn read() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        this.key = key;
        ++this.index;
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        name.setLength(0);
        try {
            name.append(this.metaData.getColumnName(++this.index));
        }
        catch (SQLException e) {
            throw Jvm.rethrow((Throwable)e);
        }
        return this.valueIn;
    }

    @Override
    @Nullable
    public <K> K readEvent(Class<K> expectedClass) {
        try {
            return (K)ObjectUtils.convertTo(expectedClass, (Object)this.metaData.getColumnName(++this.index));
        }
        catch (SQLException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    @Override
    @NotNull
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    @NotNull
    public WireIn readComment(@NotNull StringBuilder sb) {
        sb.setLength(0);
        return this;
    }

    @Override
    public boolean isEmpty() {
        try {
            return this.index >= this.metaData.getColumnCount();
        }
        catch (SQLException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    @Override
    @NotNull
    public DocumentContext readingDocument() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    @NotNull
    public DocumentContext readingDocument(long readLocation) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void consumePadding() {
    }

    @Override
    @NotNull
    public WireIn.HeaderType readDataHeader(boolean includeMetaData) throws EOFException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readAndSetLength(long position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readFirstHeader(long timeout, TimeUnit timeUnit) throws TimeoutException, StreamCorruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readMetaDataHeader() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String readingPeekYaml() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void classLookup(ClassLookup classLookup) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ClassLookup classLookup() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void pauser(Pauser pauser) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Pauser pauser() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<?> bytes() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public LongArrayValues newLongArrayReference() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object parent() {
        return this.parent;
    }

    @Override
    public void parent(Object parent) {
        this.parent = parent;
    }

    @Override
    public boolean startUse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean endUse() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public WireOut headerNumber(long headerNumber) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long headerNumber() {
        return 0L;
    }

    @Override
    @NotNull
    public ObjectInput objectInput() {
        return new WireObjectInput(this);
    }

    class RSValueIn
    implements ValueIn {
        RSValueIn() {
        }

        @Override
        @Nullable
        public String text() {
            try {
                return ResultSetWireIn.this.key == null ? ResultSetWireIn.this.resultSet.getString(ResultSetWireIn.this.index) : ResultSetWireIn.this.resultSet.getString(ResultSetWireIn.this.key.name().toString());
            }
            catch (SQLException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        }

        @Override
        @Nullable
        public StringBuilder textTo(@NotNull StringBuilder sb) {
            sb.setLength(0);
            sb.append(this.text());
            return sb;
        }

        @Override
        @Nullable
        public Bytes textTo(@NotNull Bytes bytes) {
            bytes.clear();
            bytes.appendUtf8((CharSequence)this.text());
            return bytes;
        }

        @Override
        @NotNull
        public WireIn bytes(@NotNull BytesOut bytes) {
            return this.bytes(bytes, false);
        }

        @Override
        @NotNull
        public WireIn bytes(@NotNull BytesOut toBytes, boolean clearBytes) {
            if (clearBytes) {
                toBytes.clear();
            }
            toBytes.appendUtf8((CharSequence)this.text());
            return this.wireIn();
        }

        @Override
        @Nullable
        public WireIn bytesSet(@NotNull PointerBytesStore toBytes) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireIn bytesMatch(@NotNull BytesStore compareBytes, BooleanConsumer consumer) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireIn bytes(@NotNull ReadBytesMarshallable bytesMarshallable) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public byte[] bytes() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireIn wireIn() {
            return ResultSetWireIn.this;
        }

        @Override
        public long readLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireIn skipValue() {
            return ResultSetWireIn.this;
        }

        @Override
        public boolean bool() {
            try {
                return ResultSetWireIn.this.key == null ? ResultSetWireIn.this.resultSet.getBoolean(ResultSetWireIn.this.index) : ResultSetWireIn.this.resultSet.getBoolean(ResultSetWireIn.this.key.name().toString());
            }
            catch (SQLException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        }

        @Override
        public byte int8() {
            try {
                return Maths.toInt8((long)(ResultSetWireIn.this.key == null ? (long)ResultSetWireIn.this.resultSet.getInt(ResultSetWireIn.this.index) : (long)ResultSetWireIn.this.resultSet.getInt(ResultSetWireIn.this.key.name().toString())));
            }
            catch (SQLException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        }

        @Override
        public short int16() {
            try {
                return Maths.toInt16((long)(ResultSetWireIn.this.key == null ? (long)ResultSetWireIn.this.resultSet.getInt(ResultSetWireIn.this.index) : (long)ResultSetWireIn.this.resultSet.getInt(ResultSetWireIn.this.key.name().toString())));
            }
            catch (SQLException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        }

        @Override
        public int uint16() {
            try {
                return Maths.toUInt16((long)(ResultSetWireIn.this.key == null ? (long)ResultSetWireIn.this.resultSet.getInt(ResultSetWireIn.this.index) : (long)ResultSetWireIn.this.resultSet.getInt(ResultSetWireIn.this.key.name().toString())));
            }
            catch (SQLException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        }

        @Override
        public int int32() {
            try {
                return ResultSetWireIn.this.key == null ? ResultSetWireIn.this.resultSet.getInt(ResultSetWireIn.this.index) : ResultSetWireIn.this.resultSet.getInt(ResultSetWireIn.this.key.name().toString());
            }
            catch (SQLException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        }

        @Override
        public long int64() {
            try {
                return ResultSetWireIn.this.key == null ? ResultSetWireIn.this.resultSet.getLong(ResultSetWireIn.this.index) : ResultSetWireIn.this.resultSet.getLong(ResultSetWireIn.this.key.name().toString());
            }
            catch (SQLException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        }

        @Override
        public double float64() {
            try {
                return ResultSetWireIn.this.key == null ? ResultSetWireIn.this.resultSet.getDouble(ResultSetWireIn.this.index) : ResultSetWireIn.this.resultSet.getDouble(ResultSetWireIn.this.key.name().toString());
            }
            catch (SQLException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        }

        @Override
        public float float32() {
            try {
                return ResultSetWireIn.this.key == null ? ResultSetWireIn.this.resultSet.getFloat(ResultSetWireIn.this.index) : ResultSetWireIn.this.resultSet.getFloat(ResultSetWireIn.this.key.name().toString());
            }
            catch (SQLException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        }

        @Override
        @NotNull
        public <T> WireIn bool(T t, @NotNull ObjBooleanConsumer<T> tFlag) {
            tFlag.accept(t, Boolean.valueOf(this.bool()));
            return this.wireIn();
        }

        @Override
        @NotNull
        public <T> WireIn int8(@NotNull T t, @NotNull ObjByteConsumer<T> tb) {
            tb.accept(t, this.int8());
            return this.wireIn();
        }

        @Override
        @NotNull
        public <T> WireIn uint8(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            try {
                int b = ResultSetWireIn.this.key == null ? ResultSetWireIn.this.resultSet.getInt(ResultSetWireIn.this.index) : ResultSetWireIn.this.resultSet.getInt(ResultSetWireIn.this.key.name().toString());
                ti.accept(t, Maths.toUInt8((long)b));
            }
            catch (SQLException e) {
                throw Jvm.rethrow((Throwable)e);
            }
            return this.wireIn();
        }

        @Override
        @NotNull
        public <T> WireIn int16(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            ti.accept(t, this.int16());
            return this.wireIn();
        }

        @Override
        @NotNull
        public <T> WireIn uint16(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            ti.accept(t, this.uint16());
            return this.wireIn();
        }

        @Override
        @NotNull
        public <T> WireIn int32(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            ti.accept(t, this.int32());
            return this.wireIn();
        }

        @Override
        @NotNull
        public <T> WireIn uint32(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            try {
                long b = ResultSetWireIn.this.key == null ? ResultSetWireIn.this.resultSet.getLong(ResultSetWireIn.this.index) : ResultSetWireIn.this.resultSet.getLong(ResultSetWireIn.this.key.name().toString());
                tl.accept(t, Maths.toUInt32((long)b));
            }
            catch (SQLException e) {
                throw Jvm.rethrow((Throwable)e);
            }
            return this.wireIn();
        }

        @Override
        @NotNull
        public <T> WireIn int64(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            tl.accept(t, this.int64());
            return this.wireIn();
        }

        @Override
        @NotNull
        public <T> WireIn float32(@NotNull T t, @NotNull ObjFloatConsumer<T> tf) {
            tf.accept(t, this.float32());
            return this.wireIn();
        }

        @Override
        @NotNull
        public <T> WireIn float64(@NotNull T t, @NotNull ObjDoubleConsumer<T> td) {
            td.accept(t, this.float64());
            return this.wireIn();
        }

        @Override
        @NotNull
        public <T> WireIn time(@NotNull T t, @NotNull BiConsumer<T, LocalTime> setLocalTime) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public <T> WireIn zonedDateTime(@NotNull T t, @NotNull BiConsumer<T, ZonedDateTime> tZonedDateTime) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public <T> WireIn date(@NotNull T t, @NotNull BiConsumer<T, LocalDate> tLocalDate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNextSequenceItem() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public <T> WireIn uuid(@NotNull T t, @NotNull BiConsumer<T, UUID> tuuid) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public <T> WireIn int64array(@Nullable LongArrayValues values, T t, @NotNull BiConsumer<T, LongArrayValues> setter) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireIn int64(@NotNull LongValue value) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireIn int32(@NotNull IntValue value) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public <T> WireIn int64(@Nullable LongValue value, T t, @NotNull BiConsumer<T, LongValue> setter) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public <T> WireIn int32(@Nullable IntValue value, T t, @NotNull BiConsumer<T, IntValue> setter) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public <T> boolean sequence(@NotNull T t, @NotNull BiConsumer<T, ValueIn> tReader) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> boolean sequence(List<T> list, @NotNull List<T> buffer, Supplier<T> bufferAdd, ValueIn.Reader reader0) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public <T, K> WireIn sequence(@NotNull T t, K kls, @NotNull TriConsumer<T, K, ValueIn> tReader) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public <T> T applyToMarshallable(Function<WireIn, T> marshallableReader) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public <T> T typedMarshallable() throws IORuntimeException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public <T> ValueIn typePrefix(T t, @NotNull BiConsumer<T, CharSequence> ts) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public <T> WireIn typeLiteralAsText(T t, @NotNull BiConsumer<T, CharSequence> classNameConsumer) throws IORuntimeException, BufferUnderflowException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Object marshallable(@NotNull Object object, SerializationStrategy strategy) throws BufferUnderflowException, IORuntimeException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <K extends ReadMarshallable, V extends ReadMarshallable> void typedMap(@NotNull Map<K, V> usingMap) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public <K, V> Map<K, V> map(@NotNull Class<K> kClazz, @NotNull Class<V> vClass, @NotNull Map<K, V> usingMap) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public <T> Class<T> typeLiteral() throws IORuntimeException, BufferUnderflowException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public BracketType getBracketType() {
            return BracketType.NONE;
        }

        @Override
        public boolean isNull() {
            try {
                return ResultSetWireIn.this.resultSet.wasNull();
            }
            catch (SQLException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        }

        @Override
        public Object objectWithInferredType(Object using, SerializationStrategy hint, Class type) {
            try {
                return ResultSetWireIn.this.key == null ? ResultSetWireIn.this.resultSet.getObject(ResultSetWireIn.this.index) : ResultSetWireIn.this.resultSet.getObject(ResultSetWireIn.this.key.name().toString());
            }
            catch (SQLException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        }

        @Override
        public boolean isTyped() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class typePrefix() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void resetState() {
            ResultSetWireIn.this.clear();
        }
    }
}

