/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.management;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.counters.CounterHistoryStack;
import org.nuxeo.runtime.management.counters.CounterManager;

@Operation(id="Counters.GET", category="Services", label="Retrieve counters values", description="Retrieve data collected by one or more Counters", addToStudio=false)
public class GetCounters {
    public static final String ID = "Counters.GET";
    @Context
    protected OperationContext ctx;
    @Param(name="counterNames", required=true)
    protected StringList counterNames;

    @OperationMethod
    public Blob run() throws IOException {
        NuxeoPrincipal nuxeoUser;
        CounterManager cm = (CounterManager)Framework.getService(CounterManager.class);
        LinkedHashMap collection = new LinkedHashMap();
        Principal principal = this.ctx.getPrincipal();
        if (principal instanceof NuxeoPrincipal && (nuxeoUser = (NuxeoPrincipal)principal).isAdministrator()) {
            for (String counterName : this.counterNames) {
                CounterHistoryStack stack = cm.getCounterHistory(counterName);
                ArrayList valueList = new ArrayList(stack.getAsList());
                Collections.reverse(valueList);
                ArrayList<List<Number>> valueSerie = new ArrayList<List<Number>>();
                ArrayList<List<Number>> deltaSerie = new ArrayList<List<Number>>();
                ArrayList<List<Number>> speedSerie = new ArrayList<List<Number>>();
                float lastTS = 0.0f;
                float lastValue = 0.0f;
                long now = System.currentTimeMillis();
                for (long[] values : valueList) {
                    long ts = values[0];
                    float t = (now - ts) / 1000L;
                    float value = values[1];
                    Float tFloat = Float.valueOf(ts);
                    Float bareValue = Float.valueOf(value);
                    valueSerie.add(Arrays.asList(tFloat, bareValue));
                    Float deltaValue = Float.valueOf(value - lastValue);
                    deltaSerie.add(Arrays.asList(tFloat, deltaValue));
                    if (lastTS > 0.0f) {
                        float tdelta = lastTS - t;
                        if (tdelta == 0.0f) {
                            tdelta = 1.0f;
                        }
                        Float speedValue = Float.valueOf(60.0f * (value - lastValue) / tdelta);
                        speedSerie.add(Arrays.asList(tFloat, speedValue));
                    }
                    lastTS = t;
                    lastValue = value;
                }
                LinkedHashMap<String, ArrayList<List<Number>>> counter = new LinkedHashMap<String, ArrayList<List<Number>>>();
                counter.put("values", valueSerie);
                counter.put("deltas", deltaSerie);
                counter.put("speed", speedSerie);
                collection.put(counterName, counter);
            }
        }
        return Blobs.createJSONBlobFromValue(collection);
    }
}

