/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.api;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.Literals;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.Reference;

public class Predicates {
    private Predicates() {
    }

    public static Predicate eq(String name, Object value) {
        return Predicates.createPredicate(name, Operator.EQ, value);
    }

    public static Predicate lt(String name, Object value) {
        return Predicates.createPredicate(name, Operator.LT, value);
    }

    public static Predicate lte(String name, Object value) {
        return Predicates.createPredicate(name, Operator.LTEQ, value);
    }

    public static Predicate gte(String name, Object value) {
        return Predicates.createPredicate(name, Operator.GTEQ, value);
    }

    public static Predicate gt(String name, Object value) {
        return Predicates.createPredicate(name, Operator.GT, value);
    }

    public static Predicate startsWith(String name, Object value) {
        return Predicates.createPredicate(name, Operator.STARTSWITH, value);
    }

    public static Predicate in(String name, Iterable<?> values) {
        return Predicates.createPredicate(name, Operator.IN, StreamSupport.stream(values.spliterator(), false));
    }

    public static <T> Predicate in(String name, T value, T ... values) {
        return Predicates.createPredicate(name, Operator.IN, Stream.concat(Stream.of(value), Stream.of(values)));
    }

    public static Predicate in(String name, Object[] values) {
        return Predicates.createPredicate(name, Operator.IN, Stream.of(values));
    }

    private static Predicate createPredicate(String name, Operator operator, Object value) {
        return new Predicate((Operand)new Reference(name), operator, (Operand)Literals.toLiteral((Object)value));
    }

    private static Predicate createPredicate(String name, Operator operator, Stream<?> values) {
        return new Predicate((Operand)new Reference(name), operator, (Operand)values.map(Literals::toLiteral).collect(Collectors.toCollection(LiteralList::new)));
    }
}

