/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.commandline.executor.api;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmdParameters
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, ParameterValue> params = new HashMap<String, ParameterValue>();

    public void addNamedParameter(String name, String value) {
        this.params.put(name, new ParameterValue(value));
    }

    public void addNamedParameter(String name, File file) {
        this.addNamedParameter(name, file.getAbsolutePath());
    }

    public void addNamedParameter(String name, List<String> values) {
        this.params.put(name, new ParameterValue(values));
    }

    public String getParameter(String name) {
        ParameterValue param = this.params.get(name);
        return param == null ? null : param.getValue();
    }

    public Map<String, ParameterValue> getParameters() {
        return this.params;
    }

    public static class ParameterValue {
        private final String value;
        private final List<String> values;

        public ParameterValue(String value) {
            this.value = value;
            this.values = null;
        }

        public ParameterValue(List<String> values) {
            this.values = values;
            this.value = null;
        }

        public String getValue() {
            return this.value;
        }

        public List<String> getValues() {
            return this.values;
        }

        public boolean isMulti() {
            return this.values != null;
        }
    }
}

