/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.registration.response;

import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.connect.registration.response.TrialErrorResponse;
import org.nuxeo.connect.registration.response.TrialSuccessResponse;

public abstract class TrialRegistrationResponse {
    protected JSONObject json;
    protected String type;
    protected String message;

    public String getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public static TrialRegistrationResponse read(String body) throws IOException {
        try {
            TrialRegistrationResponse o;
            String oType;
            JSONObject obj = new JSONObject(body);
            switch (oType = obj.getString("type")) {
                case "error": {
                    o = new TrialErrorResponse();
                    break;
                }
                case "message": {
                    o = new TrialSuccessResponse();
                    break;
                }
                default: {
                    throw new IOException("Unknown type: " + oType);
                }
            }
            o.readJSON(obj);
            return o;
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    protected void readJSON(JSONObject obj) throws JSONException {
        this.json = obj;
        this.type = obj.getString("type");
        this.message = obj.getString("message");
        if (obj.has("value")) {
            this.readValue(obj.get("value"));
        }
    }

    protected abstract void readValue(Object var1) throws JSONException;

    public boolean isError() {
        return "error".equals(this.type);
    }
}

