/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.reader;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.MethodReader;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import net.openhft.chronicle.wire.WireParselet;
import org.jetbrains.annotations.NotNull;

public class ChronicleHistoryReader {
    private Path basePath;
    private Consumer<String> messageSink;
    private boolean progress = false;
    private TimeUnit timeUnit = TimeUnit.NANOSECONDS;
    protected boolean histosByMethod = false;
    protected Map<String, Histogram> histos = new LinkedHashMap<String, Histogram>();

    public ChronicleHistoryReader withMessageSink(Consumer<String> messageSink) {
        this.messageSink = messageSink;
        return this;
    }

    public ChronicleHistoryReader withBasePath(Path path) {
        this.basePath = path;
        return this;
    }

    public ChronicleHistoryReader withProgress(boolean p) {
        this.progress = p;
        return this;
    }

    public ChronicleHistoryReader withTimeUnit(TimeUnit p) {
        this.timeUnit = p;
        return this;
    }

    public ChronicleHistoryReader withHistosByMethod(boolean b) {
        this.histosByMethod = b;
        return this;
    }

    @NotNull
    private SingleChronicleQueue createQueue() {
        if (!Files.exists(this.basePath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Path %s does not exist", this.basePath));
        }
        return ((SingleChronicleQueueBuilder)SingleChronicleQueueBuilder.binary(this.basePath.toFile()).readOnly(true)).build();
    }

    public void execute() {
        this.readChronicle();
        this.printPercentilesSummary();
    }

    public Map<String, Histogram> readChronicle() {
        SingleChronicleQueue q = this.createQueue();
        ExcerptTailer tailer = q.createTailer();
        WireParselet parselet = this.parselet();
        MethodReader mr = new MethodReader((MarshallableIn)tailer, true, parselet, null, new Object[]{parselet});
        MessageHistory.set((MessageHistory)new VanillaMessageHistory());
        int counter = 0;
        while (!Thread.currentThread().isInterrupted() && mr.readOne()) {
            if (!this.progress || ++counter % 1000000 != 0) continue;
            System.out.println("Progress: " + counter);
        }
        return this.histos;
    }

    public void printPercentilesSummary() {
        if (this.histos.size() == 0) {
            this.messageSink.accept("No data");
            return;
        }
        int counter = 0;
        this.messageSink.accept("Timings below in " + this.timeUnit.name());
        StringBuilder sb = new StringBuilder("sourceId        ");
        this.histos.forEach((id, histogram) -> sb.append(String.format("%12s ", id)));
        this.messageSink.accept(sb.toString());
        this.messageSink.accept("count:  " + this.count());
        this.messageSink.accept("50:     " + this.percentiles(counter++));
        this.messageSink.accept("90:     " + this.percentiles(counter++));
        this.messageSink.accept("99:     " + this.percentiles(counter++));
        this.messageSink.accept("99.9:   " + this.percentiles(counter++));
        this.messageSink.accept("99.99:  " + this.percentiles(counter++));
        this.messageSink.accept("99.999: " + this.percentiles(counter++));
        this.messageSink.accept("99.9999:" + this.percentiles(counter++));
        this.messageSink.accept("worst:  " + this.percentiles(-1));
    }

    private String count() {
        StringBuilder sb = new StringBuilder("        ");
        this.histos.forEach((id, histogram) -> sb.append(String.format("%12d ", histogram.totalCount())));
        return sb.toString();
    }

    private String percentiles(int index) {
        StringBuilder sb = new StringBuilder("        ");
        this.histos.forEach((id, histogram) -> {
            double[] percentiles = histogram.getPercentiles();
            if (index >= percentiles.length - 1) {
                sb.append(String.format("%12s ", " "));
                return;
            }
            int myIndex = index;
            if (myIndex == -1) {
                myIndex = percentiles.length - 1;
            }
            double value = percentiles[myIndex];
            sb.append(String.format("%12d ", this.timeUnit.convert((long)value, TimeUnit.NANOSECONDS)));
        });
        return sb.toString();
    }

    protected WireParselet parselet() {
        return (methodName, v, $) -> {
            v.skipValue();
            String extraHistoId = this.histosByMethod ? "_" + methodName : "";
            MessageHistory history = MessageHistory.get();
            long lastTime = 0L;
            int firstWriteOffset = history.timings() - history.sources() * 2;
            if (firstWriteOffset != 0 && firstWriteOffset != 1) {
                return;
            }
            for (int sourceIndex = 0; sourceIndex < history.sources(); ++sourceIndex) {
                Histogram histo1;
                String histoId = Integer.toString(history.sourceId(sourceIndex)) + extraHistoId;
                Histogram histo = this.histos.computeIfAbsent(histoId, s -> this.histogram());
                long receivedByThisComponent = history.timing(2 * sourceIndex + firstWriteOffset);
                long processedByThisComponent = history.timing(2 * sourceIndex + firstWriteOffset + 1);
                histo.sample(processedByThisComponent - receivedByThisComponent);
                if (lastTime == 0L && firstWriteOffset > 0) {
                    histo1 = this.histos.computeIfAbsent("startTo" + histoId, s -> this.histogram());
                    histo1.sample(receivedByThisComponent - history.timing(0));
                } else if (lastTime != 0L) {
                    histo1 = this.histos.computeIfAbsent(Integer.toString(history.sourceId(sourceIndex - 1)) + "to" + histoId, s -> this.histogram());
                    histo1.sample(receivedByThisComponent - lastTime);
                }
                lastTime = processedByThisComponent;
            }
            if (history.sources() > 1) {
                Histogram histoE2E = this.histos.computeIfAbsent("endToEnd", s -> this.histogram());
                histoE2E.sample(history.timing(history.timings() - 1) - history.timing(0));
            }
        };
    }

    @NotNull
    protected Histogram histogram() {
        return new Histogram(60, 4);
    }
}

