/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.content.converters;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConverterNotRegistered;
import org.nuxeo.ecm.diff.content.converters.AbstractContentDiffConverter;

public class ContentDiffTextConverter
extends AbstractContentDiffConverter {
    private static final String ANY_2_TEXT_CONVERTER_NAME = "any2text";

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        BlobHolder convertedBlobHolder = this.convert(ANY_2_TEXT_CONVERTER_NAME, blobHolder, parameters);
        String convertedBlobString = null;
        try {
            Blob convertedBlob = convertedBlobHolder.getBlob();
            if (convertedBlob != null) {
                convertedBlobString = convertedBlob.getString();
            }
        }
        catch (IOException e) {
            throw new ConversionException("Error while getting converted blob string.");
        }
        if (StringUtils.isEmpty((CharSequence)convertedBlobString)) {
            String srcMimeType = null;
            Blob blob = blobHolder.getBlob();
            if (blob != null) {
                srcMimeType = blob.getMimeType();
            }
            throw new ConverterNotRegistered(String.format("for sourceMimeType = %s, destinationMimeType = text/plain", srcMimeType));
        }
        return convertedBlobHolder;
    }
}

