/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.io;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.core.util.Base64;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Date;
import org.apache.commons.lang3.SerializationUtils;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.impl.ExtendedInfoImpl;

public class ExtendedInfoDeserializer
extends JsonDeserializer<ExtendedInfo> {
    public ExtendedInfo deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ExtendedInfoImpl info;
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(jp);
        switch (node.getNodeType()) {
            case STRING: {
                String value = node.textValue();
                try {
                    Date date = Date.from(Instant.parse(value));
                    info = new ExtendedInfoImpl.DateInfo(date);
                }
                catch (DateTimeParseException e) {
                    info = new ExtendedInfoImpl.StringInfo(value);
                }
                break;
            }
            case BOOLEAN: {
                info = new ExtendedInfoImpl.BooleanInfo(node.booleanValue());
                break;
            }
            case NUMBER: {
                Number number = node.numberValue();
                if (number instanceof Double) {
                    info = new ExtendedInfoImpl.DoubleInfo(node.doubleValue());
                    break;
                }
                info = new ExtendedInfoImpl.LongInfo(node.longValue());
                break;
            }
            case BINARY: {
                info = new ExtendedInfoImpl.BlobInfo((Serializable)SerializationUtils.deserialize((byte[])Base64.decode((byte[])node.binaryValue())));
                break;
            }
            case ARRAY: 
            case OBJECT: {
                info = new ExtendedInfoImpl.StringInfo(mapper.writeValueAsString((Object)node));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Error when deserializing type: " + node.getNodeType());
            }
        }
        return info;
    }
}

