/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.nuxeo.ecm.core.api.CursorResult;
import org.nuxeo.ecm.core.api.CursorService;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.persistence.PersistenceProvider;
import org.nuxeo.ecm.core.persistence.PersistenceProviderFactory;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.platform.audit.api.AuditQueryBuilder;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.FilterMapEntry;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.OrderByExprs;
import org.nuxeo.ecm.platform.audit.impl.ExtendedInfoImpl;
import org.nuxeo.ecm.platform.audit.impl.LogEntryImpl;
import org.nuxeo.ecm.platform.audit.service.AbstractAuditBackend;
import org.nuxeo.ecm.platform.audit.service.BaseLogEntryProvider;
import org.nuxeo.ecm.platform.audit.service.LogEntryProvider;
import org.nuxeo.ecm.platform.audit.service.NXAuditEventsService;
import org.nuxeo.ecm.platform.audit.service.extension.AuditBackendDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class DefaultAuditBackend
extends AbstractAuditBackend {
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected PersistenceProvider persistenceProvider;
    protected CursorService<Iterator<LogEntry>, LogEntry, String> cursorService;

    public DefaultAuditBackend(NXAuditEventsService component, AuditBackendDescriptor config) {
        super(component, config);
        this.activatePersistenceProvider();
    }

    public DefaultAuditBackend() {
    }

    @Override
    public int getApplicationStartedOrder() {
        DefaultComponent component = (DefaultComponent)Framework.getRuntime().getComponent("org.nuxeo.ecm.core.persistence.PersistenceComponent");
        return component.getApplicationStartedOrder() + 1;
    }

    @Override
    public void onApplicationStarted() {
        this.activatePersistenceProvider();
        this.cursorService = new CursorService(entry -> {
            try {
                return OBJECT_MAPPER.writeValueAsString(entry);
            }
            catch (IOException e) {
                throw new NuxeoException("Unable to serialize entry");
            }
        });
    }

    @Override
    public void onApplicationStopped() {
        try {
            this.persistenceProvider.closePersistenceUnit();
        }
        finally {
            this.persistenceProvider = null;
        }
    }

    public PersistenceProvider getOrCreatePersistenceProvider() {
        if (this.persistenceProvider == null) {
            this.activatePersistenceProvider();
        }
        return this.persistenceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activatePersistenceProvider() {
        Thread thread = Thread.currentThread();
        ClassLoader last = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(PersistenceProvider.class.getClassLoader());
            PersistenceProviderFactory persistenceProviderFactory = (PersistenceProviderFactory)Framework.getService(PersistenceProviderFactory.class);
            this.persistenceProvider = persistenceProviderFactory.newProvider("nxaudit-logs");
            this.persistenceProvider.openPersistenceUnit();
        }
        finally {
            thread.setContextClassLoader(last);
        }
    }

    protected <T> T apply(boolean needActivateSession, Function<LogEntryProvider, T> function) {
        return (T)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(needActivateSession), em -> function.apply(LogEntryProvider.createProvider(em)));
    }

    protected void accept(boolean needActivateSession, Consumer<LogEntryProvider> consumer) {
        this.getOrCreatePersistenceProvider().run(Boolean.valueOf(needActivateSession), em -> consumer.accept(LogEntryProvider.createProvider(em)));
    }

    public void addLogEntries(List<LogEntry> entries) {
        if (entries.isEmpty()) {
            return;
        }
        TransactionHelper.runInTransaction(() -> this.accept(true, provider -> provider.addLogEntries(entries)));
    }

    public List<LogEntry> getLogEntriesFor(String uuid, String repositoryId) {
        return this.apply(false, provider -> provider.getLogEntriesFor(uuid, repositoryId));
    }

    public List<LogEntry> getLogEntriesFor(String uuid) {
        return this.apply(false, provider -> provider.getLogEntriesFor(uuid));
    }

    @Override
    public List<LogEntry> getLogEntriesFor(String uuid, Map<String, FilterMapEntry> filterMap, boolean doDefaultSort) {
        return this.apply(false, provider -> provider.getLogEntriesFor(uuid, filterMap, doDefaultSort));
    }

    public LogEntry getLogEntryByID(long id) {
        return this.apply(false, provider -> provider.getLogEntryByID(id));
    }

    public List<LogEntry> nativeQueryLogs(String whereClause, int pageNb, int pageSize) {
        return this.apply(false, provider -> provider.nativeQueryLogs(whereClause, pageNb, pageSize));
    }

    public List<?> nativeQuery(String query, int pageNb, int pageSize) {
        return this.apply(false, provider -> provider.nativeQuery(query, pageNb, pageSize));
    }

    public List<?> nativeQuery(String query, Map<String, Object> params, int pageNb, int pageSize) {
        return this.apply(false, provider -> provider.nativeQuery(query, params, pageNb, pageSize));
    }

    public List<LogEntry> queryLogs(AuditQueryBuilder builder) {
        return this.apply(false, provider -> provider.queryLogs(builder));
    }

    public List<LogEntry> queryLogs(String[] eventIds, String dateRange) {
        return this.apply(false, provider -> provider.queryLogs(eventIds, dateRange));
    }

    @Override
    public List<LogEntry> queryLogsByPage(String[] eventIds, Date limit, String[] category, String path, int pageNb, int pageSize) {
        return this.apply(false, provider -> provider.queryLogsByPage(eventIds, limit, category, path, pageNb, pageSize));
    }

    public long syncLogCreationEntries(String repoId, String path, Boolean recurs) {
        return this.apply(false, provider -> this.syncLogCreationEntries((BaseLogEntryProvider)provider, repoId, path, recurs));
    }

    public Long getEventsCount(String eventId) {
        return this.apply(false, provider -> provider.countEventsById(eventId));
    }

    public List<String> getLoggedEventIds() {
        return this.apply(false, LogEntryProvider::findEventIds);
    }

    @Override
    public ExtendedInfo newExtendedInfo(Serializable value) {
        return ExtendedInfoImpl.createExtendedInfo(value);
    }

    @Override
    public long getLatestLogId(String repositoryId, String ... eventIds) {
        Map<String, Object> params = this.getParams(eventIds);
        String paramNames = this.getParamNames(eventIds);
        params.put("repoId", repositoryId);
        String query = String.format("FROM LogEntry log WHERE log.eventId IN (%s)   AND log.repositoryId = :repoId ORDER BY log.id DESC", paramNames);
        List<?> entries = this.nativeQuery(query, params, 1, 1);
        return entries.isEmpty() ? 0L : ((LogEntry)entries.get(0)).getId();
    }

    @Override
    public List<LogEntry> getLogEntriesAfter(long logIdOffset, int limit, String repositoryId, String ... eventIds) {
        Map<String, Object> params = this.getParams(eventIds);
        String paramNames = this.getParamNames(eventIds);
        params.put("repoId", repositoryId);
        params.put("minId", logIdOffset);
        String query = String.format("FROM LogEntry log WHERE log.id >= :minId   AND log.eventId IN (%s)   AND log.repositoryId = :repoId ORDER BY log.id", paramNames);
        return this.nativeQuery(query, params, 1, limit);
    }

    protected String getParamNames(String[] eventId) {
        ArrayList<String> ret = new ArrayList<String>(eventId.length);
        for (String event : eventId) {
            ret.add(":ev" + event);
        }
        return String.join((CharSequence)",", ret);
    }

    protected Map<String, Object> getParams(String[] eventId) {
        HashMap<String, Object> ret = new HashMap<String, Object>(eventId.length);
        for (String event : eventId) {
            ret.put("ev" + event, event);
        }
        return ret;
    }

    public void append(List<String> jsonEntries) {
        ArrayList<LogEntryImpl> entries = new ArrayList<LogEntryImpl>();
        for (String json : jsonEntries) {
            try {
                LogEntryImpl entry = (LogEntryImpl)OBJECT_MAPPER.readValue(json, LogEntryImpl.class);
                if (entry.getId() == 0L) {
                    throw new NuxeoException("A json entry has an empty id. entry=" + json);
                }
                entries.add(entry);
            }
            catch (IOException e) {
                throw new NuxeoException("Unable to deserialize json entries", (Throwable)e);
            }
        }
        this.accept(false, provider -> provider.append(entries));
    }

    public ScrollResult<String> scroll(AuditQueryBuilder builder, int batchSize, int keepAliveSeconds) {
        builder.orders(OrderByExprs.asc((String)"id"), (OrderByExpr[])builder.orders().toArray((Object[])new OrderByExpr[0]));
        String scrollId = this.cursorService.registerCursorResult((CursorResult)new SQLAuditCursorResult(builder, batchSize, keepAliveSeconds));
        return this.scroll(scrollId);
    }

    public ScrollResult<String> scroll(String scrollId) {
        return this.cursorService.scroll(scrollId);
    }

    public class SQLAuditCursorResult
    extends CursorResult<Iterator<LogEntry>, LogEntry> {
        protected final AuditQueryBuilder builder;
        protected long pageNb;
        protected boolean end;

        public SQLAuditCursorResult(AuditQueryBuilder builder, int batchSize, int keepAliveSeconds) {
            super(Collections.emptyIterator(), batchSize, keepAliveSeconds);
            this.builder = builder;
            this.pageNb = 0L;
        }

        public boolean hasNext() {
            if (this.cursor == null || this.end) {
                return false;
            }
            if (((Iterator)this.cursor).hasNext()) {
                return true;
            }
            this.runNextPage();
            return !this.end;
        }

        public LogEntry next() {
            if (this.cursor != null && !((Iterator)this.cursor).hasNext() && !this.end) {
                this.runNextPage();
            }
            return (LogEntry)super.next();
        }

        protected void runNextPage() {
            this.builder.offset(this.pageNb++ * (long)this.batchSize).limit((long)this.batchSize);
            this.cursor = DefaultAuditBackend.this.queryLogs(this.builder).iterator();
            this.end = !((Iterator)this.cursor).hasNext();
        }

        public void close() {
            this.end = true;
            super.close();
        }
    }
}

