/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.service.management;

import javax.management.ObjectName;
import org.nuxeo.ecm.platform.audit.api.Logs;
import org.nuxeo.ecm.platform.audit.service.NXAuditEventsService;
import org.nuxeo.ecm.platform.audit.service.management.AuditEventMetricMBean;
import org.nuxeo.ecm.platform.audit.service.management.AuditEventMetricMBeanAdapter;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.ObjectNameFactory;
import org.nuxeo.runtime.management.ResourceFactory;
import org.nuxeo.runtime.management.ResourceFactoryDescriptor;
import org.nuxeo.runtime.management.ResourcePublisherService;
import org.nuxeo.runtime.model.ComponentName;

public class AuditEventMetricFactory
implements ResourceFactory {
    protected Logs auditService;
    protected ResourcePublisherService publisherService;

    public void configure(ResourcePublisherService service, ResourceFactoryDescriptor descriptor) {
        this.publisherService = service;
        this.auditService = (Logs)Framework.getService(Logs.class);
    }

    public static String formatQualifiedName(String name) {
        return ObjectNameFactory.formatMetricQualifiedName((ComponentName)NXAuditEventsService.NAME, (String)name);
    }

    public static String formatShortcutName(String name) {
        return ObjectNameFactory.formatMetricShortName((String)("event-" + name));
    }

    public static ObjectName getObjectName(String name) {
        return ObjectNameFactory.getObjectName((String)AuditEventMetricFactory.formatQualifiedName(name));
    }

    protected void doRegisterResource(String name) {
        this.publisherService.registerResource(AuditEventMetricFactory.formatShortcutName(name), AuditEventMetricFactory.formatQualifiedName(name), AuditEventMetricMBean.class, (Object)new AuditEventMetricMBeanAdapter(this.auditService, name));
    }

    protected void doUnregisterResource(String name) {
        this.publisherService.unregisterResource(name, AuditEventMetricFactory.formatQualifiedName(name));
    }

    public void registerResources() {
        for (String name : this.auditService.getAuditableEventNames()) {
            this.doRegisterResource(name);
        }
    }
}

