/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.osgi;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.codec.CryptoProperties;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.runtime.AbstractRuntimeService;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.Version;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.impl.ComponentPersistence;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;
import org.nuxeo.runtime.osgi.OSGiRuntimeContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public class OSGiRuntimeService
extends AbstractRuntimeService
implements FrameworkListener {
    public static final ComponentName FRAMEWORK_STARTED_COMP = new ComponentName("org.nuxeo.runtime.started");
    public static final String PROP_HOME_DIR = "org.nuxeo.runtime.home";
    public static final String PROP_INSTALL_DIR = "INSTALL_DIR";
    public static final String PROP_CONFIG_DIR = "CONFIG_DIR";
    public static final String PROP_HOST_ADAPTER = "HOST_ADAPTER";
    public static final String PROP_NUXEO_BIND_ADDRESS = "nuxeo.bind.address";
    public static final String NAME = "OSGi NXRuntime";
    public static final Version VERSION = Version.parseString("1.4.0");
    private static final Log log = LogFactory.getLog(OSGiRuntimeService.class);
    private final BundleContext bundleContext;
    private final Map<String, RuntimeContext> contexts;
    private boolean appStarted = false;
    final Map<String, Bundle> bundles;
    final ComponentPersistence persistence;

    public OSGiRuntimeService(BundleContext context) {
        this(new OSGiRuntimeContext(context.getBundle()), context);
    }

    public OSGiRuntimeService(OSGiRuntimeContext runtimeContext, BundleContext context) {
        super(runtimeContext);
        this.bundleContext = context;
        this.bundles = new ConcurrentHashMap<String, Bundle>();
        this.contexts = new ConcurrentHashMap<String, RuntimeContext>();
        String bindAddress = context.getProperty(PROP_NUXEO_BIND_ADDRESS);
        if (bindAddress != null) {
            this.properties.put((Object)PROP_NUXEO_BIND_ADDRESS, (Object)bindAddress);
        }
        String homeDir = this.getProperty(PROP_HOME_DIR);
        log.debug((Object)("Home directory: " + homeDir));
        this.workingDir = homeDir != null ? new File(homeDir) : this.bundleContext.getDataFile("/");
        Environment env = Environment.getDefault();
        if (env == null) {
            env = new Environment(this.workingDir);
            Environment.setDefault((Environment)env);
            env.setServerHome(this.workingDir);
            env.init();
        }
        this.workingDir.mkdirs();
        this.persistence = new ComponentPersistence(this);
        log.debug((Object)("Working directory: " + this.workingDir));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Version getVersion() {
        return VERSION;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public Bundle getBundle(String symbolicName) {
        return this.bundles.get(symbolicName);
    }

    public Map<String, Bundle> getBundlesMap() {
        return this.bundles;
    }

    public ComponentPersistence getComponentPersistence() {
        return this.persistence;
    }

    public synchronized RuntimeContext createContext(Bundle bundle) {
        RuntimeContext ctx = this.contexts.get(bundle.getSymbolicName());
        if (ctx == null) {
            ctx = new OSGiRuntimeContext(bundle);
            this.contexts.put(bundle.getSymbolicName(), ctx);
            this.loadComponents(bundle, ctx);
        }
        return ctx;
    }

    public synchronized void destroyContext(Bundle bundle) {
        RuntimeContext ctx = this.contexts.remove(bundle.getSymbolicName());
        if (ctx != null) {
            ctx.destroy();
        }
    }

    public synchronized RuntimeContext getContext(Bundle bundle) {
        return this.contexts.get(bundle.getSymbolicName());
    }

    public synchronized RuntimeContext getContext(String symbolicName) {
        return this.contexts.get(symbolicName);
    }

    @Override
    protected void doStart() {
        this.bundleContext.addFrameworkListener((FrameworkListener)this);
        this.loadComponents(this.bundleContext.getBundle(), this.context);
    }

    @Override
    protected void doStop() {
        this.bundleContext.removeFrameworkListener((FrameworkListener)this);
        super.doStop();
    }

    protected void loadComponents(Bundle bundle, RuntimeContext ctx) {
        String list = OSGiRuntimeService.getComponentsList(bundle);
        String name = bundle.getSymbolicName();
        log.debug((Object)("Bundle: " + name + " components: " + list));
        if (list == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(list, ", \t\n\r\f");
        while (tok.hasMoreTokens()) {
            String path = tok.nextToken();
            URL url = bundle.getEntry(path);
            log.debug((Object)("Loading component for: " + name + " path: " + path + " url: " + url));
            if (url != null) {
                try {
                    ctx.deploy(url);
                    continue;
                }
                catch (IOException e) {
                    log.error((Object)("Error deploying resource: " + url));
                    throw new RuntimeServiceException("Cannot deploy: " + url, e);
                }
            }
            String message = "Unknown component '" + path + "' referenced by bundle '" + name + "'";
            log.error((Object)(message + ". Check the MANIFEST.MF"));
            this.messageHandler.addError(message);
        }
    }

    public static String getComponentsList(Bundle bundle) {
        return (String)bundle.getHeaders().get("Nuxeo-Component");
    }

    protected boolean loadConfigurationFromProvider() throws IOException {
        Iterable provider = Environment.getDefault().getConfigurationProvider();
        if (provider == null) {
            return false;
        }
        Iterator it = provider.iterator();
        ArrayList<URL> props = new ArrayList<URL>();
        ArrayList<URL> xmls = new ArrayList<URL>();
        while (it.hasNext()) {
            URL url = (URL)it.next();
            String path = url.getPath();
            if (path.endsWith("-config.xml")) {
                xmls.add(url);
                continue;
            }
            if (!path.endsWith(".properties")) continue;
            props.add(url);
        }
        xmls.sort(Comparator.comparing(URL::getPath));
        for (URL url : props) {
            this.loadProperties(url);
        }
        for (URL url : xmls) {
            this.context.deploy(url);
        }
        return true;
    }

    @Override
    protected void loadConfig() throws IOException {
        Environment env = Environment.getDefault();
        if (env == null) {
            log.warn((Object)"Configuration: no host application");
            return;
        }
        log.debug((Object)("Configuration: host application: " + env.getHostApplicationName()));
        File blacklistFile = new File(env.getConfig(), "blacklist");
        if (blacklistFile.isFile()) {
            Set<String> lines = org.apache.commons.io.FileUtils.readLines((File)blacklistFile, (Charset)StandardCharsets.UTF_8).stream().map(String::trim).filter(line -> !line.isEmpty()).collect(Collectors.toSet());
            this.manager.setBlacklist(lines);
        }
        if (this.loadConfigurationFromProvider()) {
            return;
        }
        String configDir = this.bundleContext.getProperty(PROP_CONFIG_DIR);
        if (configDir != null && configDir.contains(":/")) {
            log.debug((Object)("Configuration: " + configDir));
            URL url = new URL(configDir);
            log.debug((Object)("Configuration:   loading properties url: " + configDir));
            this.loadProperties(url);
            return;
        }
        boolean isNotJBoss4 = !OSGiRuntimeService.isJBoss4(env);
        File dir = env.getConfig();
        String[] names = dir.list();
        if (names != null) {
            Arrays.sort(names, String::compareToIgnoreCase);
            OSGiRuntimeService.printDeploymentOrderInfo(names);
            for (String name : names) {
                File file;
                if (name.endsWith("-config.xml") || name.endsWith("-bundle.xml")) {
                    if (!isNotJBoss4) continue;
                    file = new File(dir, name);
                    log.debug((Object)("Configuration: deploy config component: " + name));
                    try {
                        this.context.deploy(file.toURI().toURL());
                        continue;
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Cannot load config from " + file, e);
                    }
                }
                if (name.endsWith(".config") || name.endsWith(".ini") || name.endsWith(".properties")) {
                    file = new File(dir, name);
                    log.debug((Object)("Configuration: loading properties: " + name));
                    this.loadProperties(file);
                    continue;
                }
                log.debug((Object)("Configuration: ignoring: " + name));
            }
        } else if (dir.isFile()) {
            log.debug((Object)("Configuration: loading properties: " + dir));
            this.loadProperties(dir);
        } else {
            log.debug((Object)"Configuration: no configuration file found");
        }
        this.loadDefaultConfig();
    }

    protected static void printDeploymentOrderInfo(String[] fileNames) {
        if (log.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            for (String fileName : fileNames) {
                buf.append("\n\t").append(fileName);
            }
            log.debug((Object)("Deployment order of configuration files: " + buf.toString()));
        }
    }

    @Override
    public void reloadProperties() throws IOException {
        File dir = Environment.getDefault().getConfig();
        String[] names = dir.list();
        if (names != null) {
            Arrays.sort(names, String::compareToIgnoreCase);
            CryptoProperties props = new CryptoProperties(System.getProperties());
            for (String name : names) {
                if (!name.endsWith(".config") && !name.endsWith(".ini") && !name.endsWith(".properties")) continue;
                try (FileInputStream in = new FileInputStream(new File(dir, name));){
                    props.load((InputStream)in);
                }
            }
            this.properties = props;
        }
    }

    protected void loadDefaultConfig() {
        String varName = "org.nuxeo.ecm.contextPath";
        if (Framework.getProperty(varName) == null) {
            this.properties.setProperty(varName, "/nuxeo");
        }
    }

    public void loadProperties(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            this.loadProperties(in);
        }
    }

    public void loadProperties(URL url) throws IOException {
        try (InputStream in = url.openStream();){
            this.loadProperties(in);
        }
    }

    public void loadProperties(InputStream in) throws IOException {
        this.properties.load(in);
    }

    @Override
    public String getProperty(String name, String defValue) {
        String value = this.properties.getProperty(name);
        if (value == null && (value = this.bundleContext.getProperty(name)) == null) {
            return defValue == null ? null : this.expandVars(defValue);
        }
        if (("${" + name + "}").equals(value)) {
            return value;
        }
        return this.expandVars(value);
    }

    @Override
    public String expandVars(String expression) {
        return new TextTemplate((Properties)this.getProperties()){

            public String getVariable(String name) {
                String value = super.getVariable(name);
                if (value == null) {
                    value = OSGiRuntimeService.this.bundleContext.getProperty(name);
                }
                return value;
            }
        }.processText(expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startComponents() {
        OSGiRuntimeService oSGiRuntimeService = this;
        synchronized (oSGiRuntimeService) {
            if (this.appStarted) {
                return;
            }
            this.appStarted = true;
        }
        try {
            this.persistence.loadPersistedComponents();
        }
        catch (IOException | RuntimeException e) {
            log.error((Object)"Failed to load persisted components", (Throwable)e);
        }
        this.deployFrameworkStartedComponent();
        this.manager.start();
        this.manager.snapshot();
        this.printStatusMessage();
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() != 1) {
            return;
        }
        this.startComponents();
    }

    private void printStatusMessage() {
        StringBuilder msg = new StringBuilder();
        msg.append("Nuxeo Platform Started\n");
        if (this.getStatusMessage(msg)) {
            log.info((Object)msg);
        } else {
            log.error((Object)msg);
        }
    }

    protected void deployFrameworkStartedComponent() {
        RegistrationInfoImpl ri = new RegistrationInfoImpl(FRAMEWORK_STARTED_COMP);
        ri.setContext(this.context);
        this.manager.register(ri);
    }

    public Bundle findHostBundle(Bundle bundle) {
        String hostId = (String)bundle.getHeaders().get("Fragment-Host");
        log.debug((Object)("Looking for host bundle: " + bundle.getSymbolicName() + " host id: " + hostId));
        if (hostId != null) {
            RuntimeContext ctx;
            int p = hostId.indexOf(59);
            if (p > -1) {
                hostId = hostId.substring(0, p);
            }
            if ((ctx = this.contexts.get(hostId)) != null) {
                log.debug((Object)("Context was found for host id: " + hostId));
                return ctx.getBundle();
            }
            log.warn((Object)("No context found for host id: " + hostId));
        }
        return null;
    }

    protected File getEclipseBundleFileUsingReflection(Bundle bundle) {
        try {
            Object proxy = bundle.getClass().getMethod("getLoaderProxy", new Class[0]).invoke((Object)bundle, new Object[0]);
            Object loader = proxy.getClass().getMethod("getBundleLoader", new Class[0]).invoke(proxy, new Object[0]);
            URL root = (URL)loader.getClass().getMethod("findResource", String.class).invoke(loader, "/");
            Field field = root.getClass().getDeclaredField("handler");
            field.setAccessible(true);
            Object handler = field.get(root);
            Field entryField = handler.getClass().getSuperclass().getDeclaredField("bundleEntry");
            entryField.setAccessible(true);
            Object entry = entryField.get(handler);
            Field fileField = entry.getClass().getDeclaredField("file");
            fileField.setAccessible(true);
            return (File)fileField.get(entry);
        }
        catch (ReflectiveOperationException e) {
            log.error((Object)("Cannot access to eclipse bundle system files of " + bundle.getSymbolicName()));
            return null;
        }
    }

    @Override
    public File getBundleFile(Bundle bundle) {
        File file;
        String location = bundle.getLocation();
        String vendor = Framework.getProperty("org.osgi.framework.vendor");
        String name = bundle.getSymbolicName();
        if ("Eclipse".equals(vendor)) {
            log.debug((Object)("getBundleFile (Eclipse): " + name + "->" + location));
            return this.getEclipseBundleFileUsingReflection(bundle);
        }
        if (location.startsWith("file:")) {
            try {
                file = FileUtils.urlToFile((String)location);
            }
            catch (MalformedURLException e) {
                log.error((Object)("getBundleFile: Unable to create  for bundle: " + name + " as URI: " + location));
                return null;
            }
        } else {
            file = new File(location);
        }
        if (file.exists()) {
            log.debug((Object)("getBundleFile: " + name + " bound to file: " + file));
            return file;
        }
        log.debug((Object)("getBundleFile: " + name + " cannot bind to nonexistent file: " + file));
        return null;
    }

    public static boolean isJBoss4(Environment env) {
        if (env == null) {
            return false;
        }
        String hn = env.getHostApplicationName();
        String hv = env.getHostApplicationVersion();
        if (hn == null || hv == null) {
            return false;
        }
        return "JBoss".equals(hn) && hv.startsWith("4");
    }
}

