/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.reload;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.osgi.framework.Bundle;

public class ReloadResult {
    protected final List<Bundle> undeployedBundles = new ArrayList<Bundle>();
    protected final List<Bundle> deployedBundles = new ArrayList<Bundle>();

    public List<Bundle> undeployedBundles() {
        return this.undeployedBundles;
    }

    public List<Bundle> deployedBundles() {
        return this.deployedBundles;
    }

    public Stream<Bundle> deployedBundlesAsStream() {
        return this.deployedBundles().stream();
    }

    public Stream<File> deployedFilesAsStream() {
        return this.deployedBundlesAsStream().map(Bundle::getLocation).map(File::new);
    }

    public ReloadResult merge(ReloadResult result) {
        this.undeployedBundles.addAll(result.undeployedBundles);
        this.deployedBundles.addAll(result.deployedBundles);
        return this;
    }
}

