/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.computation;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Objects;
import org.nuxeo.lib.stream.computation.Watermark;

public class Record
implements Externalizable {
    protected static final EnumSet<Flag> DEFAULT_FLAG = EnumSet.of(Flag.DEFAULT);
    static final long serialVersionUID = 20170529L;
    public long watermark;
    public EnumSet<Flag> flags;
    public String key;
    public byte[] data;

    public Record() {
    }

    public Record(String key, byte[] data, long watermark, EnumSet<Flag> flags) {
        this.key = key;
        this.data = data;
        this.watermark = watermark;
        this.flags = flags == null ? DEFAULT_FLAG : flags;
    }

    public static Record of(String key, byte[] data) {
        return new Record(key, data, 0L, DEFAULT_FLAG);
    }

    public String toString() {
        String overview = "";
        String wmDate = "";
        if (this.data != null) {
            try {
                overview = ", data=\"" + new String(this.data, "UTF-8").substring(0, Math.min(this.data.length, 127)) + '\"';
            }
            catch (UnsupportedEncodingException e) {
                overview = "unsupported encoding";
            }
            overview = overview.replaceAll("[^\\x20-\\x7e]", ".");
        }
        if (this.watermark > 0L) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            Watermark wm = Watermark.ofValue(this.watermark);
            wmDate = ", wmDate=" + dateFormat.format(new Date(wm.getTimestamp()));
        }
        return "Record{watermark=" + this.watermark + wmDate + ", flags=" + this.flags + ", key='" + this.key + '\'' + ", data.length=" + (this.data == null ? 0 : this.data.length) + overview + '}';
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.watermark);
        out.writeShort(this.encodeFlags());
        out.writeObject(this.key);
        if (this.data == null || this.data.length == 0) {
            out.writeInt(0);
        } else {
            out.writeInt(this.data.length);
            out.write(this.data);
        }
    }

    protected short encodeFlags() {
        short ret = 0;
        if (this.flags != null) {
            for (Flag val : this.flags) {
                ret = (short)(ret | 1 << val.ordinal());
            }
        }
        return ret;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.watermark = in.readLong();
        this.flags = this.decodeFlags(in.readShort());
        this.key = (String)in.readObject();
        int dataLength = in.readInt();
        if (dataLength == 0) {
            this.data = null;
        } else {
            int byteRead;
            this.data = new byte[dataLength];
            for (int pos = 0; pos < dataLength; pos += byteRead) {
                byteRead = in.read(this.data, pos, dataLength - pos);
                if (byteRead != -1) continue;
                throw new IllegalStateException("Corrupted stream, can not read " + dataLength + " bytes");
            }
        }
    }

    protected EnumSet<Flag> decodeFlags(short encoded) {
        HashMap<Integer, Flag> ordinalMap = new HashMap<Integer, Flag>();
        for (Flag val : Flag.ALL_OPTS) {
            ordinalMap.put(val.ordinal(), val);
        }
        EnumSet<Flag> ret = EnumSet.noneOf(Flag.class);
        int ordinal = 0;
        for (int i = 1; i != 0; i <<= 1) {
            if ((i & encoded) != 0) {
                ret.add((Flag)((Object)ordinalMap.get(ordinal)));
            }
            ++ordinal;
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Record record = (Record)o;
        return this.watermark == record.watermark && Objects.equals(this.flags, record.flags) && Objects.equals(this.key, record.key) && Arrays.equals(this.data, record.data);
    }

    public int hashCode() {
        int result = Objects.hash(this.watermark, this.flags, this.key);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public static enum Flag {
        DEFAULT,
        COMMIT,
        POISON_PILL;

        public static final EnumSet<Flag> ALL_OPTS;

        static {
            ALL_OPTS = EnumSet.allOf(Flag.class);
        }
    }
}

