/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.nuxeo.lib.stream.log.LogLag;

public class Latency {
    protected final LogLag lag;
    protected long lower;
    protected long upper;
    protected String key;

    public Latency(long lower, long upper, LogLag lag, String key) {
        Objects.requireNonNull(lag);
        this.lower = lower;
        this.upper = upper;
        this.lag = lag;
        this.key = key;
    }

    public static Latency noLatency(long upper, LogLag lag) {
        Objects.requireNonNull(lag);
        if (lag.lag() != 0L) {
            throw new IllegalArgumentException("Lag found: " + lag);
        }
        return new Latency(0L, upper, lag, null);
    }

    public static Latency fromJson(String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode obj = mapper.readTree(json);
            long lower = obj.get("low").asLong();
            long upper = obj.get("up").asLong();
            long lag = obj.get("lag").asLong();
            String key = obj.get("key") == null ? null : obj.get("key").asText();
            return new Latency(lower, upper, LogLag.of(lag), key);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid json: " + json, e);
        }
    }

    public static Latency of(List<Latency> latencies) {
        LogLag lag = LogLag.of(latencies.stream().map(Latency::lag).collect(Collectors.toList()));
        long[] start = new long[]{Long.MAX_VALUE};
        long[] end = new long[]{0L};
        String[] key = new String[]{""};
        latencies.forEach(item -> {
            if (item.lower > 0L && item.lower < start[0]) {
                start[0] = item.lower;
                key[0] = item.key;
            }
            end[0] = Math.max(end[0], item.upper);
        });
        return new Latency(start[0] == Long.MAX_VALUE ? 0L : start[0], end[0], lag, key[0]);
    }

    public long latency() {
        return this.lag.lag() > 0L ? this.upper - this.lower : 0L;
    }

    public long lower() {
        return this.lower;
    }

    public long upper() {
        return this.upper;
    }

    public LogLag lag() {
        return this.lag;
    }

    public String key() {
        return this.key;
    }

    public String toString() {
        return "Latency{lat=" + this.latency() + ", lower=" + this.lower + ", upper=" + this.upper + ", key=" + this.key + ", lag=" + this.lag + '}';
    }

    public String asJson() {
        return String.format("{\"lat\":\"%s\",\"low\":\"%s\",\"up\":\"%s\",\"lag\":\"%s\"%s}", this.latency(), this.lower, this.upper, this.lag.lag, this.key == null ? "" : ",\"key\":\"" + this.key + "\"");
    }
}

