/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log;

import java.io.Externalizable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.nuxeo.lib.stream.log.Latency;
import org.nuxeo.lib.stream.log.LogAppender;
import org.nuxeo.lib.stream.log.LogLag;
import org.nuxeo.lib.stream.log.LogPartition;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.log.RebalanceListener;

public interface LogManager
extends AutoCloseable {
    public boolean exists(String var1);

    public boolean createIfNotExists(String var1, int var2);

    public boolean delete(String var1);

    public <M extends Externalizable> LogAppender<M> getAppender(String var1);

    public <M extends Externalizable> LogTailer<M> createTailer(String var1, Collection<LogPartition> var2);

    default public <M extends Externalizable> LogTailer<M> createTailer(String group, LogPartition partition) {
        return this.createTailer(group, Collections.singletonList(partition));
    }

    default public <M extends Externalizable> LogTailer<M> createTailer(String group, String name) {
        int size = this.getAppender(name).size();
        return this.createTailer(group, IntStream.range(0, size).boxed().map(partition -> new LogPartition(name, (int)partition)).collect(Collectors.toList()));
    }

    public boolean supportSubscribe();

    public <M extends Externalizable> LogTailer<M> subscribe(String var1, Collection<String> var2, RebalanceListener var3);

    public List<LogLag> getLagPerPartition(String var1, String var2);

    default public LogLag getLag(String name, String group) {
        return LogLag.of(this.getLagPerPartition(name, group));
    }

    public <M extends Externalizable> List<Latency> getLatencyPerPartition(String var1, String var2, Function<M, Long> var3, Function<M, String> var4);

    default public <M extends Externalizable> Latency getLatency(String name, String group, Function<M, Long> timestampExtractor, Function<M, String> keyExtractor) {
        return Latency.of(this.getLatencyPerPartition(name, group, timestampExtractor, keyExtractor));
    }

    public List<String> listAll();

    public List<String> listConsumerGroups(String var1);

    @Override
    public void close();
}

