/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log.kafka;

import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Bytes;
import org.nuxeo.lib.stream.log.LogOffset;
import org.nuxeo.lib.stream.log.internals.CloseableLogAppender;
import org.nuxeo.lib.stream.log.internals.LogOffsetImpl;
import org.nuxeo.lib.stream.log.kafka.KafkaLogTailer;
import org.nuxeo.lib.stream.log.kafka.KafkaNamespace;

public class KafkaLogAppender<M extends Externalizable>
implements CloseableLogAppender<M> {
    private static final Log log = LogFactory.getLog(KafkaLogAppender.class);
    protected final String topic;
    protected final Properties consumerProps;
    protected final Properties producerProps;
    protected final int size;
    protected final ConcurrentLinkedQueue<KafkaLogTailer<M>> tailers = new ConcurrentLinkedQueue();
    protected final String name;
    protected final KafkaNamespace ns;
    protected KafkaProducer<String, Bytes> producer;
    protected boolean closed;

    private KafkaLogAppender(KafkaNamespace ns, String name, Properties producerProperties, Properties consumerProperties) {
        this.ns = ns;
        this.topic = ns.getTopicName(name);
        this.name = name;
        this.producerProps = producerProperties;
        this.consumerProps = consumerProperties;
        this.producer = new KafkaProducer(this.producerProps);
        this.size = this.producer.partitionsFor(this.topic).size();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Created appender: %s on topic: %s with %d partitions", name, this.topic, this.size));
        }
    }

    public static <M extends Externalizable> KafkaLogAppender<M> open(KafkaNamespace ns, String name, Properties producerProperties, Properties consumerProperties) {
        return new KafkaLogAppender<M>(ns, name, producerProperties, consumerProperties);
    }

    @Override
    public String name() {
        return this.name;
    }

    public String getTopic() {
        return this.topic;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public LogOffset append(int partition, Externalizable message) {
        RecordMetadata result;
        Bytes value = Bytes.wrap((byte[])this.messageAsByteArray(message));
        String key = String.valueOf(partition);
        ProducerRecord record = new ProducerRecord(this.topic, Integer.valueOf(partition), (Object)key, (Object)value);
        Future future = this.producer.send(record);
        try {
            result = (RecordMetadata)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Unable to send record: " + record, e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Unable to send record: " + record, e);
        }
        LogOffsetImpl ret = new LogOffsetImpl(this.name, partition, result.offset());
        if (log.isDebugEnabled()) {
            int len = ((Bytes)record.value()).get().length;
            log.debug((Object)String.format("append to %s-%02d:+%d, len: %d, key: %s, value: %s", this.name, partition, ret.offset(), len, key, message));
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] messageAsByteArray(Externalizable message) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(message);
            out.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitFor(LogOffset offset, String group, Duration timeout) throws InterruptedException {
        boolean ret = false;
        if (!this.name.equals(offset.partition().name())) {
            throw new IllegalArgumentException(this.name + " can not wait for an offset with a different Log: " + offset);
        }
        TopicPartition topicPartition = new TopicPartition(this.topic, offset.partition().partition());
        try {
            ret = this.isProcessed(group, topicPartition, offset.offset());
            if (ret) {
                boolean bl = true;
                return bl;
            }
            long timeoutMs = timeout.toMillis();
            long deadline = System.currentTimeMillis() + timeoutMs;
            long delay = Math.min(100L, timeoutMs);
            while (!ret && System.currentTimeMillis() < deadline) {
                Thread.sleep(delay);
                ret = this.isProcessed(group, topicPartition, offset.offset());
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("waitFor " + offset + "/" + group + " returns: " + ret));
            }
        }
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    protected boolean isProcessed(String group, TopicPartition topicPartition, long offset) {
        Properties props = (Properties)this.consumerProps.clone();
        props.put("group.id", this.ns.getKafkaGroup(group));
        try (KafkaConsumer consumer = new KafkaConsumer(props);){
            boolean ret;
            consumer.assign(Collections.singletonList(topicPartition));
            long last = consumer.position(topicPartition);
            boolean bl = ret = last > 0L && last > offset;
            if (log.isDebugEnabled()) {
                log.debug((Object)("isProcessed " + topicPartition.topic() + ":" + topicPartition.partition() + "/" + group + ":+" + offset + "? " + ret + ", current position: " + last));
            }
            boolean bl2 = ret;
            return bl2;
        }
    }

    @Override
    public void close() {
        log.debug((Object)("Closing appender: " + this.name));
        this.tailers.stream().filter(Objects::nonNull).forEach(tailer -> {
            try {
                tailer.close();
            }
            catch (Exception e) {
                log.error((Object)("Failed to close tailer: " + tailer));
            }
        });
        this.tailers.clear();
        if (this.producer != null) {
            this.producer.close();
            this.producer = null;
        }
        this.closed = true;
    }
}

