/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log.kafka;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kafka.admin.AdminClient;
import kafka.admin.AdminUtils;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.coordinator.group.GroupOverview;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.ZkConnection;
import org.I0Itec.zkclient.exception.ZkTimeoutException;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.nuxeo.lib.stream.log.LogPartition;
import scala.collection.JavaConversions;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;

public class KafkaUtils
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(KafkaUtils.class);
    public static final String ZK_SERVERS_PROP = "kafka.zkServers";
    public static final String DEFAULT_ZK_SERVERS = "localhost:2181";
    public static final String BOOTSTRAP_SERVERS_PROP = "kafka.bootstrap.servers";
    public static final String DEFAULT_BOOTSTRAP_SERVERS = "localhost:9092";
    public static final int ZK_TIMEOUT_MS = 6000;
    public static final int ZK_CONNECTION_TIMEOUT_MS = 10000;
    protected final ZkClient zkClient;
    protected final ZkUtils zkUtils;
    protected final Properties adminProperties;
    protected AdminClient adminClient;
    protected org.apache.kafka.clients.admin.AdminClient newAdminClient;
    protected java.util.List<String> allConsumers;
    protected long allConsumersTime;
    protected static final long ALL_CONSUMERS_CACHE_TIMEOUT_MS = 2000L;

    public KafkaUtils() {
        this(KafkaUtils.getZkServers(), KafkaUtils.getDefaultAdminProperties());
    }

    public KafkaUtils(String zkServers, Properties adminProperties) {
        log.debug((Object)("Init zkServers: " + zkServers));
        this.zkClient = KafkaUtils.createZkClient(zkServers);
        this.zkUtils = KafkaUtils.createZkUtils(zkServers, this.zkClient);
        this.adminProperties = adminProperties;
    }

    public static Properties getDefaultAdminProperties() {
        Properties ret = new Properties();
        ret.put("bootstrap.servers", KafkaUtils.getBootstrapServers());
        return ret;
    }

    public static String getZkServers() {
        return System.getProperty(ZK_SERVERS_PROP, DEFAULT_ZK_SERVERS);
    }

    public static String getBootstrapServers() {
        return System.getProperty(BOOTSTRAP_SERVERS_PROP, DEFAULT_BOOTSTRAP_SERVERS);
    }

    public static boolean kafkaDetected() {
        return KafkaUtils.kafkaDetected(KafkaUtils.getZkServers());
    }

    public static boolean kafkaDetected(String zkServers) {
        try {
            ZkClient tmp = new ZkClient(zkServers, 1000, 1000, (ZkSerializer)ZKStringSerializer$.MODULE$);
            tmp.close();
        }
        catch (ZkTimeoutException e) {
            return false;
        }
        return true;
    }

    protected static ZkUtils createZkUtils(String zkServers, ZkClient zkClient) {
        return new ZkUtils(zkClient, new ZkConnection(zkServers), false);
    }

    protected static ZkClient createZkClient(String zkServers) {
        return new ZkClient(zkServers, 6000, 10000, (ZkSerializer)ZKStringSerializer$.MODULE$);
    }

    public static java.util.List<java.util.List<LogPartition>> rangeAssignments(int threads, java.util.Map<String, Integer> streams) {
        RangeAssignor assignor = new RangeAssignor();
        return KafkaUtils.assignments((PartitionAssignor)assignor, threads, streams);
    }

    public static java.util.List<java.util.List<LogPartition>> roundRobinAssignments(int threads, java.util.Map<String, Integer> streams) {
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        return KafkaUtils.assignments((PartitionAssignor)assignor, threads, streams);
    }

    protected static java.util.List<java.util.List<LogPartition>> assignments(PartitionAssignor assignor, int threads, java.util.Map<String, Integer> streams) {
        ArrayList parts = new ArrayList();
        streams.forEach((streamName, size) -> parts.addAll(KafkaUtils.getPartsFor(streamName, size)));
        HashMap<String, PartitionAssignor.Subscription> subscriptions = new HashMap<String, PartitionAssignor.Subscription>();
        java.util.List streamNames = streams.keySet().stream().sorted().collect(Collectors.toList());
        for (int i = 0; i < threads; ++i) {
            subscriptions.put(String.valueOf(i), new PartitionAssignor.Subscription(streamNames));
        }
        Cluster cluster = new Cluster("kafka-cluster", Collections.emptyList(), parts, Collections.emptySet(), Collections.emptySet());
        java.util.Map assignments = assignor.assign(cluster, subscriptions);
        ArrayList<java.util.List<LogPartition>> ret = new ArrayList<java.util.List<LogPartition>>(threads);
        for (int i = 0; i < threads; ++i) {
            ret.add(((PartitionAssignor.Assignment)assignments.get(String.valueOf(i))).partitions().stream().map(part -> new LogPartition(part.topic(), part.partition())).collect(Collectors.toList()));
        }
        return ret;
    }

    protected static Collection<PartitionInfo> getPartsFor(String topic, int partitions) {
        ArrayList<PartitionInfo> ret = new ArrayList<PartitionInfo>();
        for (int i = 0; i < partitions; ++i) {
            ret.add(new PartitionInfo(topic, i, null, null, null));
        }
        return ret;
    }

    public void createTopicWithoutReplication(String topic, int partitions) {
        this.createTopic(topic, partitions, (short)1);
    }

    public void createTopic(String topic, int partitions, short replicationFactor) {
        log.info((Object)("Creating topic: " + topic + ", partitions: " + partitions + ", replications: " + replicationFactor));
        if (this.topicExists(topic)) {
            throw new IllegalArgumentException("Cannot create Topic already exists: " + topic);
        }
        CreateTopicsResult ret = this.getNewAdminClient().createTopics(Collections.singletonList(new NewTopic(topic, partitions, replicationFactor)));
        try {
            ret.all().get(5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Unable to create topics " + topic + " within the timeout", e);
        }
    }

    public boolean topicExists(String topic) {
        return AdminUtils.topicExists((ZkUtils)this.zkUtils, (String)topic);
    }

    public java.util.List<String> listTopics() {
        Seq topics = this.zkUtils.getAllTopics();
        return JavaConversions.seqAsJavaList((Seq)topics);
    }

    public java.util.List<String> listConsumers(String topic) {
        return this.listAllConsumers().stream().filter(consumer -> this.getConsumerTopics((String)consumer).contains(topic)).collect(Collectors.toList());
    }

    protected java.util.List<String> getConsumerTopics(String group) {
        return JavaConversions.mapAsJavaMap((Map)this.getAdminClient().listGroupOffsets(group)).keySet().stream().map(TopicPartition::topic).collect(Collectors.toList());
    }

    protected org.apache.kafka.clients.admin.AdminClient getNewAdminClient() {
        if (this.newAdminClient == null) {
            this.newAdminClient = org.apache.kafka.clients.admin.AdminClient.create((Properties)this.adminProperties);
        }
        return this.newAdminClient;
    }

    protected AdminClient getAdminClient() {
        if (this.adminClient == null) {
            this.adminClient = AdminClient.create((Properties)this.adminProperties);
        }
        return this.adminClient;
    }

    public java.util.List<String> listAllConsumers() {
        long now = System.currentTimeMillis();
        if (this.allConsumers == null || now - this.allConsumersTime > 2000L) {
            this.allConsumers = new ArrayList<String>();
            List groups = this.getAdminClient().listAllConsumerGroupsFlattened();
            for (GroupOverview group : groups) {
                if (group == null || this.allConsumers.contains(group.groupId())) continue;
                this.allConsumers.add(group.groupId());
            }
            if (!this.allConsumers.isEmpty()) {
                this.allConsumersTime = now;
            }
        }
        return this.allConsumers;
    }

    public void markTopicForDeletion(String topic) {
        log.debug((Object)("mark topic for deletion: " + topic));
        AdminUtils.deleteTopic((ZkUtils)this.zkUtils, (String)topic);
    }

    public int getNumberOfPartitions(String topic) {
        DescribeTopicsResult descriptions = this.getNewAdminClient().describeTopics(Collections.singletonList(topic));
        try {
            return ((TopicDescription)((KafkaFuture)descriptions.values().get(topic)).get()).partitions().size();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void resetConsumerStates(String topic) {
        log.debug((Object)"Resetting consumer states");
        AdminUtils.deleteAllConsumerGroupInfoForTopicInZK((ZkUtils)this.zkUtils, (String)topic);
    }

    public Set<String> getBrokerEndPoints() {
        HashSet<String> ret = new HashSet<String>();
        Seq brokers = this.zkUtils.getAllBrokersInCluster();
        for (Broker broker : brokers) {
            if (broker == null) continue;
            Seq endPoints = broker.endPoints();
            for (EndPoint endPoint : endPoints) {
                ret.add(endPoint.connectionString());
            }
        }
        return ret;
    }

    public String getDefaultBootstrapServers() {
        return this.getBrokerEndPoints().stream().collect(Collectors.joining(","));
    }

    @Override
    public void close() {
        if (this.zkUtils != null) {
            this.zkUtils.close();
        }
        if (this.zkClient != null) {
            this.zkClient.close();
        }
        if (this.adminClient != null) {
            this.adminClient.close();
            this.adminClient = null;
        }
        if (this.newAdminClient != null) {
            this.newAdminClient.close();
            this.newAdminClient = null;
        }
        log.debug((Object)"Closed.");
    }
}

