/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.Watermark;
import org.nuxeo.lib.stream.log.Latency;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.internals.LogPartitionGroup;

public class LatencyTrackerComputation
extends AbstractComputation {
    protected static final String OUTPUT_STREAM = "o1";
    protected final LogManager manager;
    protected final List<String> logNames;
    protected final int intervalMs;
    protected final int count;
    protected final boolean verbose;
    protected int remaining;
    protected List<LogPartitionGroup> logGroups;

    public LatencyTrackerComputation(LogManager manager, List<String> logNames, String computationName, int intervalSecond, int count, boolean verbose) {
        super(computationName, 1, 1);
        this.manager = manager;
        this.logNames = logNames;
        this.intervalMs = 1000 * intervalSecond;
        this.count = count;
        this.remaining = count;
        this.verbose = verbose;
    }

    @Override
    public void init(ComputationContext context) {
        this.info(String.format("Tracking %s, count: %d, interval: %dms", Arrays.toString(this.logNames.toArray()), this.count, this.intervalMs));
        this.logGroups = new ArrayList<LogPartitionGroup>();
        this.logNames.forEach(name -> {
            for (String group : this.manager.listConsumerGroups((String)name)) {
                this.logGroups.add(new LogPartitionGroup(group, (String)name, 0));
            }
        });
        context.setTimer("tracker", System.currentTimeMillis() + (long)this.intervalMs);
    }

    @Override
    public void processTimer(ComputationContext context, String key, long timestamp) {
        if (this.remaining == 0) {
            this.debug("Exiting after " + this.count + " captures");
            context.askForTermination();
            return;
        }
        this.debug(String.format("Tracking latency %d/%d", this.count - this.remaining, this.count));
        for (LogPartitionGroup logGroup : this.logGroups) {
            List<Latency> latencies;
            try {
                latencies = this.manager.getLatencyPerPartition(logGroup.name, logGroup.group, rec -> Watermark.ofValue(rec.watermark).getTimestamp(), rec -> rec.key);
            }
            catch (IllegalStateException e) {
                this.error("log does not contains Record: " + logGroup);
                continue;
            }
            int partition = 0;
            for (Latency latency : latencies) {
                byte[] value;
                String recordKey = LatencyTrackerComputation.encodeKey(logGroup, partition);
                try {
                    value = latency.asJson().getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException("Faild to byte encoding " + latency, e);
                }
                Record record = new Record(recordKey, value, Watermark.ofTimestamp(latency.upper()).getValue(), null);
                this.debug("out: " + record);
                context.produceRecord(OUTPUT_STREAM, record);
                context.setSourceLowWatermark(latency.upper());
                ++partition;
            }
        }
        context.askForCheckpoint();
        context.setTimer("tracker", System.currentTimeMillis() + (long)this.intervalMs);
        --this.remaining;
    }

    public static String encodeKey(LogPartitionGroup logGroup, int partition) {
        return String.format("%s:%s:%s", logGroup.group, logGroup.name, partition);
    }

    public static LogPartitionGroup decodeKey(String key) {
        String[] parts = key.split(":");
        return new LogPartitionGroup(parts[0], parts[1], Integer.parseInt(parts[2]));
    }

    @Override
    public void destroy() {
        this.info("Good bye");
    }

    @Override
    public void processRecord(ComputationContext context, String inputStreamName, Record record) {
        this.error("Receiving a record is not expected!: " + record);
    }

    protected void debug(String msg) {
        if (this.verbose) {
            System.out.println(msg);
        }
    }

    protected void info(String msg) {
        System.out.println(msg);
    }

    protected void error(String msg) {
        System.err.println(msg);
    }
}

