/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import java.io.UnsupportedEncodingException;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.jetbrains.annotations.NotNull;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.Watermark;
import org.nuxeo.lib.stream.log.Latency;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.LogOffset;
import org.nuxeo.lib.stream.log.LogRecord;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.log.internals.LogPartitionGroup;
import org.nuxeo.lib.stream.tools.command.Command;
import org.nuxeo.lib.stream.tools.command.LatencyTrackerComputation;
import org.nuxeo.lib.stream.tools.command.PositionCommand;

public class RestoreCommand
extends Command {
    protected static final String NAME = "restore";
    protected static final String GROUP = "tools";
    protected boolean verbose = false;
    protected String input;
    protected List<String> logNames;
    protected long date;
    protected boolean dryRun;

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void updateOptions(Options options) {
        options.addOption(Option.builder((String)"l").longOpt("log-name").desc("Restore consumers positions for this LOG, must be a computation Record, can be a comma separated list of log names or ALL").required().hasArg().argName("LOG_NAME").build());
        options.addOption(Option.builder((String)"i").longOpt("log-input").desc("Log name of the input default to _consumer_latencies").hasArg().argName("LOG_OUTPUT").build());
        options.addOption(Option.builder().longOpt("to-date").desc("Sets the committed positions as they where at a specific date. The date is specified in ISO-8601 format, eg. " + Instant.now()).hasArg().argName("DATE").build());
        options.addOption(Option.builder().longOpt("verbose").build());
        options.addOption(Option.builder().longOpt("dry-run").desc("Do not change any position").build());
    }

    @Override
    public boolean run(LogManager manager, CommandLine cmd) throws InterruptedException {
        this.logNames = this.getLogNames(manager, cmd.getOptionValue("log-name"));
        this.input = cmd.getOptionValue("log-input");
        this.date = PositionCommand.getTimestampFromDate(cmd.getOptionValue("to-date"));
        this.verbose = cmd.hasOption("verbose");
        this.dryRun = cmd.hasOption("dry-run");
        return this.restorePosition(manager);
    }

    protected boolean restorePosition(LogManager manager) throws InterruptedException {
        Map<LogPartitionGroup, Latency> latencies = this.readLatencies(manager);
        Map<LogPartitionGroup, LogOffset> offsets = this.searchOffsets(manager, latencies);
        if (this.dryRun) {
            System.out.println("# Dry run mode returning without doing any changes");
            return true;
        }
        this.updatePositions(manager, offsets);
        return true;
    }

    protected void updatePositions(LogManager manager, Map<LogPartitionGroup, LogOffset> offsets) {
        offsets.forEach((key, offset) -> this.updatePosition(manager, (LogPartitionGroup)key, (LogOffset)offset));
    }

    protected void updatePosition(LogManager manager, LogPartitionGroup key, LogOffset offset) {
        if (offset == null) {
            return;
        }
        System.out.println("# Commit : " + key);
        try (LogTailer tailer = manager.createTailer(key.group, key.getLogPartition());){
            tailer.seek(offset);
            tailer.commit();
        }
    }

    protected Map<LogPartitionGroup, LogOffset> searchOffsets(LogManager manager, Map<LogPartitionGroup, Latency> latencies) throws InterruptedException {
        HashMap<LogPartitionGroup, LogOffset> ret = new HashMap<LogPartitionGroup, LogOffset>(latencies.size());
        System.out.println("# Searching offsets matching the latencies");
        for (LogPartitionGroup key : latencies.keySet()) {
            ret.put(key, this.findOffset(manager, key, latencies.get(key)));
        }
        return ret;
    }

    protected LogOffset findOffset(LogManager manager, LogPartitionGroup key, Latency latency) throws InterruptedException {
        long targetWatermark = latency.lower();
        String targetKey = latency.key();
        try (LogTailer tailer = manager.createTailer(key.group, key.getLogPartition());){
            LogRecord rec = tailer.read(PositionCommand.FIRST_READ_TIMEOUT);
            while (rec != null) {
                long timestamp;
                if ((targetKey == null || targetKey.equals(((Record)rec.message()).key)) && targetWatermark == (timestamp = Watermark.ofValue(((Record)rec.message()).watermark).getTimestamp())) {
                    System.out.println("Offset found: " + key + ": " + rec.offset());
                    LogOffset logOffset = rec.offset().nextOffset();
                    return logOffset;
                }
                rec = tailer.read(PositionCommand.READ_TIMEOUT);
            }
        }
        System.err.println("No offset found for: " + key);
        return null;
    }

    @NotNull
    private Map<LogPartitionGroup, Latency> readLatencies(LogManager manager) throws InterruptedException {
        HashMap<LogPartitionGroup, Latency> latencies = new HashMap<LogPartitionGroup, Latency>();
        System.out.println("# Reading latencies from: " + this.input + " ...");
        try (LogTailer tailer = manager.createTailer(GROUP, this.input);){
            LogRecord rec = tailer.read(PositionCommand.FIRST_READ_TIMEOUT);
            while (rec != null) {
                long timestamp = Watermark.ofValue(((Record)rec.message()).watermark).getTimestamp();
                if (this.date <= 0L || timestamp <= this.date) {
                    Latency latency2;
                    LogPartitionGroup key2 = LatencyTrackerComputation.decodeKey(((Record)rec.message()).key);
                    if (this.logNames.contains(key2.name) && (latency2 = this.decodeLatency(((Record)rec.message()).data)) != null) {
                        latencies.put(key2, latency2);
                    }
                }
                rec = tailer.read(PositionCommand.READ_TIMEOUT);
            }
        }
        System.out.println("# Latencies found: ");
        latencies.forEach((key, latency) -> System.out.println(String.format("%s: %s", key, latency)));
        return latencies;
    }

    protected Latency decodeLatency(byte[] data) {
        try {
            return Latency.fromJson(new String(data, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Cannot decode message" + e.getMessage() + " " + Arrays.toString(data));
            return null;
        }
    }

    protected List<String> getLogNames(LogManager manager, String names) {
        if ("all".equals(names.toLowerCase())) {
            return manager.listAll().stream().filter(name -> !name.startsWith("_")).collect(Collectors.toList());
        }
        List<String> ret = Arrays.asList(names.split(","));
        for (String name2 : ret) {
            if (manager.exists(name2)) continue;
            throw new IllegalArgumentException("Unknown log name: " + name2);
        }
        return ret;
    }
}

