/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.statuses;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.management.api.ProbeInfo;

public class HealthCheckResult {
    private static final Log log = LogFactory.getLog(HealthCheckResult.class);
    protected Collection<ProbeInfo> probes;
    protected boolean healthy;

    public HealthCheckResult(Collection<ProbeInfo> probesToCheck) {
        this.probes = probesToCheck;
        this.healthy = this.probes.stream().allMatch(p -> p.getStatus().isSuccess());
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    public String toJson() {
        ObjectMapper om = new ObjectMapper();
        HashMap<String, String> res = new HashMap<String, String>();
        try {
            for (ProbeInfo probe : this.probes) {
                res.put(probe.getShortcutName(), probe.getStatus().isSuccess() ? "ok" : "failed");
            }
            return om.writeValueAsString(res);
        }
        catch (JsonProcessingException e) {
            log.error((Object)e);
            return "";
        }
    }
}

