/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jaxrs.io.documents;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.automation.core.operations.business.adapter.BusinessAdapter;
import org.nuxeo.ecm.automation.io.services.codec.ObjectCodecService;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;
import org.nuxeo.runtime.api.Framework;

@Provider
@Consumes(value={"application/json+nxentity", "application/json"})
public class BusinessAdapterReader
implements MessageBodyReader<BusinessAdapter> {
    @Context
    protected HttpServletRequest request;
    @Context
    JsonFactory factory;

    private CoreSession getCoreSession() {
        return SessionFactory.getSession((HttpServletRequest)this.request);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return BusinessAdapter.class.isAssignableFrom(type);
    }

    public BusinessAdapter readFrom(Class<BusinessAdapter> arg0, Type arg1, Annotation[] arg2, MediaType arg3, MultivaluedMap<String, String> headers, InputStream in) throws IOException, WebApplicationException {
        return this.readRequest(in, headers);
    }

    public BusinessAdapter readRequest(InputStream in, MultivaluedMap<String, String> headers) throws IOException, WebApplicationException {
        String content = IOUtils.toString((InputStream)in, (String)"UTF-8");
        if (content.isEmpty()) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        return this.readRequest(content, headers);
    }

    public BusinessAdapter readRequest(String content, MultivaluedMap<String, String> headers) throws WebApplicationException {
        try {
            return this.readRequest0(content, headers);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public BusinessAdapter readRequest0(String content, MultivaluedMap<String, String> headers) throws IOException {
        ObjectCodecService codecService = (ObjectCodecService)Framework.getService(ObjectCodecService.class);
        try (JsonParser jp = this.factory.createParser(content);){
            JsonNode inputNode = (JsonNode)jp.readValueAsTree();
            BusinessAdapter businessAdapter = (BusinessAdapter)codecService.readNode(inputNode, this.getCoreSession());
            return businessAdapter;
        }
    }
}

