/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.web.resources.api.ResourceBundle;

@XObject(value="bundle")
public class ResourceBundleDescriptor
implements ResourceBundle {
    private static final long serialVersionUID = 1L;
    @XNode(value="@name")
    public String name;
    @XNode(value="resources@append")
    boolean append;
    @XNodeList(value="resources/resource", type=ArrayList.class, componentType=String.class)
    List<String> resources;

    public String getName() {
        return this.name;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public ResourceBundleDescriptor clone() {
        ResourceBundleDescriptor c = new ResourceBundleDescriptor();
        c.name = this.name;
        c.append = this.append;
        if (this.resources != null) {
            c.resources = new ArrayList<String>(this.resources);
        }
        return c;
    }

    public ResourceBundle merge(ResourceBundle other) {
        if (other instanceof ResourceBundleDescriptor) {
            boolean append = ((ResourceBundleDescriptor)other).isAppend();
            List res = other.getResources();
            ArrayList<String> merged = new ArrayList<String>();
            if (append && this.resources != null) {
                merged.addAll(this.resources);
            }
            if (res != null) {
                merged.addAll(res);
            }
            this.resources = merged;
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResourceBundleDescriptor)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ResourceBundleDescriptor b = (ResourceBundleDescriptor)obj;
        return new EqualsBuilder().append((Object)this.name, (Object)b.name).append(this.append, b.append).append(this.resources, b.resources).isEquals();
    }
}

