/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import com.sun.xml.xsom.ForeignAttributes;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSListSimpleType;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.XmlString;
import com.sun.xml.xsom.impl.RestrictionSimpleTypeImpl;
import com.sun.xml.xsom.parser.XSOMParser;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.Namespace;
import org.nuxeo.ecm.core.schema.SchemaBindingDescriptor;
import org.nuxeo.ecm.core.schema.SchemaManagerImpl;
import org.nuxeo.ecm.core.schema.XSDTypes;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.ComplexTypeImpl;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.ListTypeImpl;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.SchemaImpl;
import org.nuxeo.ecm.core.schema.types.SimpleType;
import org.nuxeo.ecm.core.schema.types.SimpleTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.TypeBindingException;
import org.nuxeo.ecm.core.schema.types.TypeException;
import org.nuxeo.ecm.core.schema.types.constraints.AbstractConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;
import org.nuxeo.ecm.core.schema.types.constraints.ConstraintUtils;
import org.nuxeo.ecm.core.schema.types.constraints.DateIntervalConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.EnumConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.LengthConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.NotNullConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.NumericIntervalConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.ObjectResolverConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.PatternConstraint;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolver;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolverService;
import org.nuxeo.runtime.api.Framework;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XSDLoader {
    private static final String ATTR_CORE_EXTERNAL_REFERENCES = "resolver";
    private static final String ATTR_CORE_EXTERNAL_REFERENCES_VALIDATION = "validation";
    private static final Log log = LogFactory.getLog(XSDLoader.class);
    private static final String ANONYMOUS_TYPE_SUFFIX = "#anonymousType";
    private static final String NAMESPACE_CORE_VALIDATION = "http://www.nuxeo.org/ecm/schemas/core/validation/";
    private static final String NAMESPACE_CORE_EXTERNAL_REFERENCES = "http://www.nuxeo.org/ecm/schemas/core/external-references/";
    private static final String NS_XSD = "http://www.w3.org/2001/XMLSchema";
    protected final SchemaManagerImpl schemaManager;
    protected List<String> referencedXSD = new ArrayList<String>();
    protected boolean collectReferencedXSD = false;
    protected SchemaBindingDescriptor sd;
    private ObjectResolverService referenceService;

    protected ObjectResolverService getObjectResolverService() {
        if (this.referenceService == null) {
            this.referenceService = (ObjectResolverService)Framework.getService(ObjectResolverService.class);
        }
        return this.referenceService;
    }

    public XSDLoader(SchemaManagerImpl schemaManager) {
        this.schemaManager = schemaManager;
    }

    public XSDLoader(SchemaManagerImpl schemaManager, SchemaBindingDescriptor sd) {
        this.schemaManager = schemaManager;
        this.sd = sd;
    }

    public XSDLoader(SchemaManagerImpl schemaManager, boolean collectReferencedXSD) {
        this.schemaManager = schemaManager;
        this.collectReferencedXSD = collectReferencedXSD;
    }

    protected void registerSchema(Schema schema) {
        this.schemaManager.registerSchema(schema);
    }

    protected Type getType(String name) {
        return this.schemaManager.getType(name);
    }

    protected XSOMParser getParser() {
        XSOMParser parser = new XSOMParser();
        SchemaErrorHandler errorHandler = new SchemaErrorHandler();
        parser.setErrorHandler((ErrorHandler)errorHandler);
        if (this.sd != null) {
            parser.setEntityResolver((EntityResolver)new NXSchemaResolver(this.schemaManager, this.sd));
        }
        return parser;
    }

    public Schema loadSchema(String name, String prefix, File file) throws SAXException, IOException, TypeException {
        return this.loadSchema(name, prefix, file, null);
    }

    public Schema loadSchema(String name, String prefix, File file, String xsdElement) throws SAXException, IOException, TypeException {
        return this.loadSchema(name, prefix, file, xsdElement, false);
    }

    public Schema loadSchema(String name, String prefix, File file, String xsdElement, boolean isVersionWritable) throws SAXException, IOException, TypeException {
        XSOMParser parser = this.getParser();
        String systemId = file.toURI().toURL().toExternalForm();
        if (file.getPath().startsWith("\\\\")) {
            systemId = systemId.replace("file://", "file:////");
        }
        try {
            parser.parse(systemId);
        }
        catch (SAXParseException e) {
            throw new SAXException("Error parsing schema: " + systemId, e);
        }
        XSSchemaSet xsSchemas = parser.getResult();
        if (this.collectReferencedXSD) {
            this.collectReferencedXSD(xsSchemas);
        }
        return this.loadSchema(name, prefix, xsSchemas, xsdElement, isVersionWritable);
    }

    protected void collectReferencedXSD(XSSchemaSet xsSchemas) {
        Collection schemas = xsSchemas.getSchemas();
        for (XSSchema s : schemas) {
            String filePath;
            String systemId;
            String ns = s.getTargetNamespace();
            if (ns.length() <= 0 || ns.equals(NS_XSD) || (systemId = s.getLocator().getSystemId()) == null || !systemId.startsWith("file:/") || this.referencedXSD.contains(filePath = systemId.substring(6))) continue;
            this.referencedXSD.add(filePath);
        }
    }

    public Schema loadSchema(String name, String prefix, URL url, String xsdElement) throws SAXException, TypeException {
        XSOMParser parser = this.getParser();
        parser.parse(url);
        XSSchemaSet xsSchemas = parser.getResult();
        return this.loadSchema(name, prefix, xsSchemas, xsdElement);
    }

    public Schema loadSchema(String name, String prefix, URL url) throws SAXException, TypeException {
        return this.loadSchema(name, prefix, url, null);
    }

    protected Schema loadSchema(String name, String prefix, XSSchemaSet schemaSet, String xsdElement) throws SAXException, TypeException {
        return this.loadSchema(name, prefix, schemaSet, xsdElement, false);
    }

    protected Schema loadSchema(String name, String prefix, XSSchemaSet schemaSet, String xsdElement, boolean isVersionWritable) throws SAXException, TypeException {
        if (schemaSet == null) {
            return null;
        }
        Collection schemas = schemaSet.getSchemas();
        XSSchema schema = null;
        String ns = null;
        for (XSSchema s : schemas) {
            ns = s.getTargetNamespace();
            if (ns.length() <= 0 || ns.equals(NS_XSD)) continue;
            schema = s;
            break;
        }
        if (schema == null) {
            return null;
        }
        SchemaImpl ecmSchema = new SchemaImpl(name, new Namespace(ns, prefix), isVersionWritable);
        Collection elements = schema.getElementDecls().values();
        for (Object el : elements) {
            Type ecmType = this.loadType(ecmSchema, el.getType(), el.getName());
            if (ecmType != null) {
                XSDLoader.createField(ecmSchema, (XSElementDecl)el, ecmType);
                continue;
            }
            log.warn((Object)("Failed to load field " + el.getName() + " : " + el.getType()));
        }
        Collection attributes = schema.getAttributeDecls().values();
        for (XSAttributeDecl att : attributes) {
            Type ecmType = this.loadType(ecmSchema, (XSType)att.getType(), att.getName());
            if (ecmType != null) {
                XSDLoader.createField(ecmSchema, att, ecmType, true);
                continue;
            }
            log.warn((Object)("Failed to load field from attribute " + att.getName() + " : " + att.getType()));
        }
        if (xsdElement != null) {
            Field singleComplexField = ecmSchema.getField(xsdElement);
            if (singleComplexField == null) {
                log.warn((Object)("Unable to find element " + xsdElement + " to rebase schema " + name));
            } else if (singleComplexField.getType().isComplexType()) {
                ComplexType singleComplexFieldType = (ComplexType)singleComplexField.getType();
                ecmSchema = new SchemaImpl(singleComplexFieldType, name, new Namespace(ns, prefix), isVersionWritable);
            } else {
                log.warn((Object)("can not rebase schema " + name + " on " + xsdElement + " that is not a complex type"));
            }
        }
        this.registerSchema(ecmSchema);
        return ecmSchema;
    }

    protected Type loadType(Schema schema, XSType type, String fieldName) throws TypeBindingException {
        Type ecmType;
        String name;
        if (type.getName() == null || type.isLocal()) {
            name = XSDLoader.getAnonymousTypeName(type, fieldName);
            if (name == null) {
                log.warn((Object)"Unable to load type - no name found");
                return null;
            }
        } else {
            name = type.getName();
        }
        if ((ecmType = this.getType(name)) != null) {
            return ecmType;
        }
        ecmType = schema.getType(name);
        if (ecmType != null) {
            return ecmType;
        }
        if (type.getTargetNamespace().equals(NS_XSD)) {
            ecmType = XSDTypes.getType(name);
            if (ecmType == null) {
                log.warn((Object)("Cannot use unknown XSD type: " + name));
            }
            return ecmType;
        }
        ecmType = type.isSimpleType() ? (type instanceof XSListSimpleType ? this.loadListType(schema, (XSListSimpleType)type, fieldName) : this.loadSimpleType(schema, type, fieldName)) : this.loadComplexType(schema, name, (XSType)type.asComplexType());
        if (ecmType != null) {
            schema.registerType(ecmType);
        } else {
            log.warn((Object)("loadType for " + fieldName + " of " + type + " returns null"));
        }
        return ecmType;
    }

    protected Type loadComplexType(Schema schema, String name, XSType type) throws TypeBindingException {
        Type ret;
        XSComplexType xsct;
        XSContentType content;
        XSType baseType = type.getBaseType();
        ComplexType superType = null;
        if (baseType.getBaseType() != baseType) {
            if (baseType.isComplexType()) {
                superType = (ComplexType)this.loadType(schema, baseType, name);
            } else {
                log.warn((Object)"Complex type has a non complex type super type???");
            }
        }
        if ((content = (xsct = type.asComplexType()).getExplicitContent()) == null) {
            content = xsct.getContentType();
        }
        if ((ret = this.createComplexType(schema, superType, name, content, xsct.isAbstract())) != null && ret instanceof ComplexType) {
            this.loadAttributes(schema, xsct, (ComplexType)ret);
        }
        return ret;
    }

    protected void loadAttributes(Schema schema, XSComplexType xsct, ComplexType ct) throws TypeBindingException {
        Collection attrs = xsct.getAttributeUses();
        for (XSAttributeUse attr : attrs) {
            XSAttributeDecl at = attr.getDecl();
            Type fieldType = this.loadType(schema, (XSType)at.getType(), at.getName());
            if (fieldType == null) {
                throw new TypeBindingException("Cannot add type for '" + at.getName() + "'");
            }
            XSDLoader.createField(ct, at, fieldType, !attr.isRequired());
        }
    }

    protected SimpleType loadSimpleType(Schema schema, XSType type, String fieldName) throws TypeBindingException {
        String name = type.getName();
        if (name == null) {
            name = fieldName + ANONYMOUS_TYPE_SUFFIX;
        }
        XSType baseType = type.getBaseType();
        SimpleType superType = null;
        if (baseType != type) {
            superType = (SimpleType)this.loadType(schema, baseType, fieldName);
        }
        SimpleTypeImpl simpleType = new SimpleTypeImpl(superType, schema.getName(), name);
        if (type instanceof RestrictionSimpleTypeImpl) {
            List enumFacets;
            RestrictionSimpleTypeImpl restrictionType = (RestrictionSimpleTypeImpl)type;
            ArrayList<Constraint> constraints = new ArrayList<Constraint>();
            XSFacet patternFacet = restrictionType.getFacet("pattern");
            if (patternFacet != null) {
                if (simpleType.getPrimitiveType().support(PatternConstraint.class)) {
                    String pattern = patternFacet.getValue().toString();
                    PatternConstraint constraint = new PatternConstraint(pattern);
                    constraints.add(constraint);
                } else {
                    this.logUnsupportedFacetRestriction(schema, fieldName, simpleType, "pattern");
                }
            }
            XSFacet minLengthFacet = restrictionType.getFacet("minLength");
            XSFacet maxLengthFacet = restrictionType.getFacet("maxLength");
            XSFacet lengthFacet = restrictionType.getFacet("length");
            if (maxLengthFacet != null || minLengthFacet != null || lengthFacet != null) {
                if (simpleType.getPrimitiveType().support(LengthConstraint.class)) {
                    String min = null;
                    String max = null;
                    if (lengthFacet != null) {
                        max = min = lengthFacet.getValue().toString();
                    } else {
                        if (minLengthFacet != null) {
                            min = minLengthFacet.getValue();
                        }
                        if (maxLengthFacet != null) {
                            max = maxLengthFacet.getValue();
                        }
                    }
                    LengthConstraint constraint = new LengthConstraint(min, max);
                    constraints.add(constraint);
                } else {
                    this.logUnsupportedFacetRestriction(schema, fieldName, simpleType, "minLength", "maxLength", "length");
                }
            }
            XSFacet minExclusiveFacet = restrictionType.getFacet("minExclusive");
            XSFacet minInclusiveFacet = restrictionType.getFacet("minInclusive");
            XSFacet maxExclusiveFacet = restrictionType.getFacet("maxExclusive");
            XSFacet maxInclusiveFacet = restrictionType.getFacet("maxInclusive");
            if (minExclusiveFacet != null || minInclusiveFacet != null || maxExclusiveFacet != null || maxInclusiveFacet != null) {
                AbstractConstraint constraint;
                boolean includingMax;
                boolean includingMin;
                XmlString max;
                XmlString min;
                if (simpleType.getPrimitiveType().support(NumericIntervalConstraint.class)) {
                    min = null;
                    max = null;
                    includingMin = true;
                    includingMax = true;
                    if (minExclusiveFacet != null) {
                        min = minExclusiveFacet.getValue();
                        includingMin = false;
                    } else if (minInclusiveFacet != null) {
                        min = minInclusiveFacet.getValue();
                        includingMin = true;
                    }
                    if (maxExclusiveFacet != null) {
                        max = maxExclusiveFacet.getValue();
                        includingMax = false;
                    } else if (maxInclusiveFacet != null) {
                        max = maxInclusiveFacet.getValue();
                        includingMax = true;
                    }
                    constraint = new NumericIntervalConstraint(min, includingMin, max, includingMax);
                    constraints.add(constraint);
                } else if (simpleType.getPrimitiveType().support(DateIntervalConstraint.class)) {
                    min = null;
                    max = null;
                    includingMin = true;
                    includingMax = true;
                    if (minExclusiveFacet != null) {
                        min = minExclusiveFacet.getValue();
                        includingMin = false;
                    }
                    if (minInclusiveFacet != null) {
                        min = minInclusiveFacet.getValue();
                        includingMin = true;
                    }
                    if (maxExclusiveFacet != null) {
                        max = maxExclusiveFacet.getValue();
                        includingMax = false;
                    }
                    if (maxInclusiveFacet != null) {
                        max = maxInclusiveFacet.getValue();
                        includingMax = true;
                    }
                    constraint = new DateIntervalConstraint(min, includingMin, max, includingMax);
                    constraints.add(constraint);
                } else {
                    this.logUnsupportedFacetRestriction(schema, fieldName, simpleType, "minExclusive", "minInclusive", "maxExclusive", "maxInclusive");
                }
            }
            if ((enumFacets = restrictionType.getFacets("enumeration")) != null && enumFacets.size() > 0) {
                if (simpleType.getPrimitiveType().support(EnumConstraint.class)) {
                    ArrayList<String> enumValues = new ArrayList<String>();
                    for (XSFacet enumFacet : enumFacets) {
                        enumValues.add(enumFacet.getValue().toString());
                    }
                    EnumConstraint constraint = new EnumConstraint(enumValues);
                    constraints.add(constraint);
                } else {
                    this.logUnsupportedFacetRestriction(schema, fieldName, simpleType, "enumeration");
                }
            }
            String refName = restrictionType.getForeignAttribute(NAMESPACE_CORE_EXTERNAL_REFERENCES, ATTR_CORE_EXTERNAL_REFERENCES);
            HashMap<String, String> refParameters = new HashMap<String, String>();
            for (ForeignAttributes attr : restrictionType.getForeignAttributes()) {
                for (int index = 0; index < attr.getLength(); ++index) {
                    String attrNS = attr.getURI(index);
                    String attrName = attr.getLocalName(index);
                    String attrValue = attr.getValue(index);
                    if (!NAMESPACE_CORE_EXTERNAL_REFERENCES.equals(attrNS) || ATTR_CORE_EXTERNAL_REFERENCES.equals(attrName)) continue;
                    refParameters.put(attrName, attrValue);
                }
            }
            if (refName != null) {
                ObjectResolver resolver = this.getObjectResolverService().getResolver(refName, refParameters);
                if (resolver != null) {
                    simpleType.setResolver(resolver);
                    String validation = refParameters.getOrDefault(ATTR_CORE_EXTERNAL_REFERENCES_VALIDATION, Boolean.TRUE.toString());
                    if (Boolean.parseBoolean(validation)) {
                        constraints.add(new ObjectResolverConstraint(resolver));
                    }
                } else {
                    log.info((Object)("type of " + fieldName + "|" + type.getName() + " targets ObjectResolver namespace but has no matching resolver registered " + "(please contribute to component : org.nuxeo.ecm.core.schema.ObjectResolverService)"));
                }
            }
            simpleType.addConstraints(constraints);
        }
        return simpleType;
    }

    private void logUnsupportedFacetRestriction(Schema schema, String fieldName, SimpleTypeImpl simpleType, String ... facetNames) {
        StringBuilder msg = new StringBuilder();
        msg.append("schema|field|type : ").append(schema.getName());
        msg.append("|").append(fieldName);
        msg.append("|").append(simpleType.getPrimitiveType());
        msg.append(" following restriction facet are not handled by constraints API for this type :");
        for (String facetName : facetNames) {
            msg.append(facetName).append(" ");
        }
        log.warn((Object)msg.toString());
    }

    protected ListType loadListType(Schema schema, XSListSimpleType type, String fieldName) throws TypeBindingException {
        XSSimpleType xsItemType;
        SimpleType itemType;
        String name = type.getName();
        if (name == null) {
            name = fieldName + ANONYMOUS_TYPE_SUFFIX;
        }
        if ((itemType = (xsItemType = type.getItemType()).getTargetNamespace().equals(NS_XSD) ? XSDTypes.getType(xsItemType.getName()) : this.loadSimpleType(schema, (XSType)xsItemType, null)) == null) {
            log.error((Object)"list item type was not defined -> you should define first the item type");
            return null;
        }
        return new ListTypeImpl(schema.getName(), name, itemType);
    }

    protected Type createComplexType(Schema schema, ComplexType superType, String name, XSContentType content, boolean abstractType) throws TypeBindingException {
        ComplexTypeImpl ct = new ComplexTypeImpl(superType, schema.getName(), name);
        schema.registerType(ct);
        XSParticle particle = content.asParticle();
        if (particle == null) {
            return ct;
        }
        XSTerm term = particle.getTerm();
        XSModelGroup mg = term.asModelGroup();
        return this.processModelGroup(schema, superType, name, ct, mg, abstractType);
    }

    protected Type createFakeComplexType(Schema schema, ComplexType superType, String name, XSModelGroup mg) throws TypeBindingException {
        ComplexTypeImpl ct = new ComplexTypeImpl(superType, schema.getName(), name);
        schema.registerType(ct);
        return this.processModelGroup(schema, superType, name, ct, mg, false);
    }

    protected Type processModelGroup(Schema schema, ComplexType superType, String name, ComplexType ct, XSModelGroup mg, boolean abstractType) throws TypeBindingException {
        if (mg == null) {
            throw new TypeBindingException("unsupported complex type");
        }
        XSParticle[] group = mg.getChildren();
        if (group.length == 0) {
            return null;
        }
        if (group.length == 1 && superType == null && group[0].isRepeated() && !abstractType) {
            return this.createListType(schema, name, group[0]);
        }
        for (XSParticle child : group) {
            String fieldName;
            ListType listType;
            XSTerm term = child.getTerm();
            XSElementDecl element = term.asElementDecl();
            int maxOccur = child.getMaxOccurs().intValue();
            if (element == null) {
                if (maxOccur < 0 || maxOccur > 1) {
                    Type fakeType = this.createFakeComplexType(schema, superType, name + "#anonymousListItem", term.asModelGroup());
                    listType = XSDLoader.createListType(schema, name + "#anonymousListType", fakeType, 0, maxOccur);
                    fieldName = ct.getName() + "#anonymousList";
                    ct.addField(fieldName, listType, null, 0, null);
                    continue;
                }
                this.processModelGroup(schema, superType, name, ct, term.asModelGroup(), abstractType);
                continue;
            }
            if (maxOccur < 0 || maxOccur > 1) {
                Type fieldType = this.loadType(schema, element.getType(), element.getName());
                if (fieldType == null) continue;
                listType = XSDLoader.createListType(schema, element.getName() + "#anonymousListType", fieldType, 0, maxOccur);
                fieldName = element.getName();
                ct.addField(fieldName, listType, null, 0, null);
                continue;
            }
            this.loadComplexTypeElement(schema, ct, element);
        }
        if (superType != null && superType.isComplexType()) {
            for (Field parentField : superType.getFields()) {
                ct.addField(parentField.getName().getLocalName(), parentField.getType(), (String)parentField.getDefaultValue(), 0, null);
            }
        }
        return ct;
    }

    protected ListType createListType(Schema schema, String name, XSParticle particle) throws TypeBindingException {
        boolean computedNillable;
        XSElementDecl element = particle.getTerm().asElementDecl();
        if (element == null) {
            log.warn((Object)("Ignoring " + name + " unsupported list type"));
            return null;
        }
        Type type = this.loadType(schema, element.getType(), element.getName());
        if (type == null) {
            log.warn((Object)("Unable to find type for " + element.getName()));
            return null;
        }
        XmlString dv = element.getDefaultValue();
        String defValue = null;
        if (dv != null) {
            defValue = dv.value;
        }
        int flags = 0;
        if (defValue == null && (dv = element.getFixedValue()) != null) {
            defValue = dv.value;
            flags |= 2;
        }
        if (computedNillable = XSDLoader.isNillable(element)) {
            flags |= 1;
        }
        HashSet<Constraint> constraints = new HashSet<Constraint>();
        if (!computedNillable) {
            constraints.add(NotNullConstraint.get());
        }
        if (type instanceof SimpleType) {
            SimpleType st = (SimpleType)type;
            constraints.addAll(st.getConstraints());
        }
        return new ListTypeImpl(schema.getName(), name, type, element.getName(), defValue, flags, constraints, particle.getMinOccurs().intValue(), particle.getMaxOccurs().intValue());
    }

    protected static ListType createListType(Schema schema, String name, Type itemType, int min, int max) throws TypeBindingException {
        String elementName = name + "#item";
        return new ListTypeImpl(schema.getName(), name, itemType, elementName, null, min, max);
    }

    protected void loadComplexTypeElement(Schema schema, ComplexType type, XSElementDecl element) throws TypeBindingException {
        XSType elementType = element.getType();
        Type fieldType = this.loadType(schema, elementType, element.getName());
        if (fieldType != null) {
            XSDLoader.createField(type, element, fieldType);
        }
    }

    protected static Field createField(ComplexType type, XSElementDecl element, Type fieldType) {
        LengthConstraint lc;
        boolean computedNillable;
        String elementName = element.getName();
        XmlString dv = element.getDefaultValue();
        String defValue = null;
        if (dv != null) {
            defValue = dv.value;
        }
        int flags = 0;
        if (defValue == null && (dv = element.getFixedValue()) != null) {
            defValue = dv.value;
            flags |= 2;
        }
        if (computedNillable = XSDLoader.isNillable(element)) {
            flags |= 1;
        }
        HashSet<Constraint> constraints = new HashSet<Constraint>();
        if (!computedNillable) {
            constraints.add(NotNullConstraint.get());
        }
        if (fieldType instanceof SimpleType) {
            SimpleType st = (SimpleType)fieldType;
            constraints.addAll(st.getConstraints());
        }
        Field field = type.addField(elementName, fieldType, defValue, flags, constraints);
        if (fieldType instanceof SimpleTypeImpl && (lc = ConstraintUtils.getConstraint(field.getConstraints(), LengthConstraint.class)) != null && lc.getMax() != null) {
            field.setMaxLength(lc.getMax().intValue());
        }
        return field;
    }

    protected static Field createField(ComplexType type, XSAttributeDecl element, Type fieldType, boolean isNillable) {
        String elementName = element.getName();
        XmlString dv = element.getDefaultValue();
        String defValue = null;
        if (dv != null) {
            defValue = dv.value;
        }
        int flags = 0;
        if (defValue == null && (dv = element.getFixedValue()) != null) {
            defValue = dv.value;
            flags |= 2;
        }
        HashSet<Constraint> constraints = new HashSet<Constraint>();
        if (!isNillable) {
            constraints.add(NotNullConstraint.get());
        }
        if (fieldType.isSimpleType()) {
            constraints.addAll(fieldType.getConstraints());
        }
        return type.addField(elementName, fieldType, defValue, flags, constraints);
    }

    protected static String getAnonymousTypeName(XSType type, String fieldName) {
        if (type.isComplexType()) {
            XSElementDecl container = type.asComplexType().getScope();
            String elName = container.getName();
            return elName + ANONYMOUS_TYPE_SUFFIX;
        }
        return fieldName + ANONYMOUS_TYPE_SUFFIX;
    }

    public List<String> getReferencedXSD() {
        return this.referencedXSD;
    }

    protected static boolean isNillable(XSElementDecl element) {
        String value = element.getForeignAttribute(NAMESPACE_CORE_VALIDATION, "nillable");
        boolean computedNillable = element.isNillable() || value == null || Boolean.parseBoolean(value);
        return computedNillable;
    }

    protected static class SchemaErrorHandler
    implements ErrorHandler {
        protected SchemaErrorHandler() {
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            log.error((Object)("Error: " + e.getMessage()));
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            log.error((Object)("FatalError: " + e.getMessage()));
            throw e;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            log.error((Object)("Warning: " + e.getMessage()));
        }
    }

    protected static class NXSchemaResolver
    implements EntityResolver {
        protected SchemaManagerImpl schemaManager;
        protected SchemaBindingDescriptor sd;

        NXSchemaResolver(SchemaManagerImpl schemaManager, SchemaBindingDescriptor sd) {
            this.schemaManager = schemaManager;
            this.sd = sd;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            String[] parts = systemId.split("/schemas/");
            String importXSDSubPath = parts[1];
            File xsd = new File(this.schemaManager.getSchemasDir(), importXSDSubPath);
            if (!xsd.exists()) {
                int idx = this.sd.src.lastIndexOf("/");
                importXSDSubPath = this.sd.src.substring(0, idx + 1) + importXSDSubPath;
                URL url = this.sd.context.getLocalResource(importXSDSubPath);
                if (url == null) {
                    url = this.sd.context.getResource(importXSDSubPath);
                }
                if (url != null) {
                    return new InputSource(url.openStream());
                }
            }
            return null;
        }
    }
}

