/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Normalizer;
import org.apache.commons.io.IOUtils;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;

public final class FileManagerUtils {
    private FileManagerUtils() {
    }

    @Deprecated
    public static byte[] getBytesFromFile(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            byte[] byArray = IOUtils.toByteArray((InputStream)in);
            return byArray;
        }
    }

    public static String fetchFileName(File file) throws MalformedURLException {
        URL pathUrl = file.toURI().toURL();
        String[] pathArray = pathUrl.getFile().split("/");
        return pathArray[pathArray.length - 1];
    }

    public static String fetchFileName(String fullName) {
        int lastUnixSeparator;
        String ret = fullName;
        int lastWinSeparator = fullName.lastIndexOf(92);
        int lastSeparator = Math.max(lastWinSeparator, lastUnixSeparator = fullName.lastIndexOf(47));
        if (lastSeparator != -1) {
            ret = fullName.substring(lastSeparator + 1, fullName.length());
        }
        return ret;
    }

    public static String fetchTitle(String filename) {
        String title = filename.trim();
        if (title.length() == 0) {
            title = IdUtils.generateStringId();
        }
        return title;
    }

    public static DocumentModel getExistingDocByFileName(CoreSession documentManager, String path, String filename) {
        return FileManagerUtils.getExistingDocByPropertyName(documentManager, path, filename, "content/name");
    }

    public static DocumentModel getExistingDocByTitle(CoreSession documentManager, String path, String title) {
        return FileManagerUtils.getExistingDocByPropertyName(documentManager, path, title, "dc:title");
    }

    public static DocumentModel getExistingDocByPropertyName(CoreSession documentManager, String path, String value, String propertyName) {
        value = Normalizer.normalize(value, Normalizer.Form.NFC);
        DocumentModel existing = null;
        String parentId = documentManager.getDocument((DocumentRef)new PathRef(path)).getId();
        String query = "SELECT * FROM Document WHERE ecm:parentId = '" + parentId + "' AND " + propertyName + " = '" + value.replace("'", "\\'") + "' AND ecm:isTrashed = 0";
        DocumentModelList docs = documentManager.query(query, 1);
        if (docs.size() > 0) {
            existing = (DocumentModel)docs.get(0);
        }
        return existing;
    }
}

