/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.international;

import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.SeamResourceBundle;
import org.jboss.seam.util.Strings;

public class StatusMessage
implements Serializable {
    private String summaryTemplate;
    private String summary;
    private String detailTemplate;
    private String detail;
    private Severity severity = Severity.INFO;

    public StatusMessage(Severity severity, String key, String detailKey, String defaultMessageTemplate, String defaultMessageDetailTemplate) {
        this.summaryTemplate = StatusMessage.getBundleMessage(key, defaultMessageTemplate);
        this.detailTemplate = StatusMessage.getBundleMessage(detailKey, defaultMessageDetailTemplate);
        if (!Strings.isEmpty(this.summaryTemplate)) {
            this.severity = severity;
        }
    }

    public boolean isEmpty() {
        return Strings.isEmpty(this.summary) && Strings.isEmpty(this.summaryTemplate);
    }

    public void interpolate(Object ... params) {
        if (!Strings.isEmpty(this.summaryTemplate)) {
            this.summary = Interpolator.instance().interpolate(this.summaryTemplate, params);
        }
        if (!Strings.isEmpty(this.detailTemplate)) {
            this.detail = Interpolator.instance().interpolate(this.detailTemplate, params);
        }
    }

    public String getSummary() {
        return this.summary;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getDetail() {
        return this.detail;
    }

    public static String getBundleMessage(String key, String defaultMessageTemplate) {
        ResourceBundle resourceBundle;
        String messageTemplate = defaultMessageTemplate;
        if (key != null && (resourceBundle = SeamResourceBundle.getBundle()) != null) {
            try {
                String bundleMessage = resourceBundle.getString(key);
                if (bundleMessage != null) {
                    messageTemplate = bundleMessage;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return messageTemplate;
    }

    public String toString() {
        return "[" + (Object)((Object)this.severity) + "] " + this.summary + " (" + this.detail + ")";
    }

    public static enum Severity {
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

