/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.query.api.Aggregate;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.api.AggregateRangeDateDefinition;
import org.nuxeo.ecm.platform.query.api.AggregateRangeDefinition;
import org.nuxeo.ecm.platform.query.api.Bucket;
import org.nuxeo.ecm.platform.query.api.PredicateFieldDefinition;
import org.nuxeo.ecm.platform.query.core.MockBucket;

public class AggregateBase<B extends Bucket>
implements Aggregate<B> {
    protected final AggregateDefinition definition;
    protected final DocumentModel searchDocument;
    protected List<String> selection;
    protected List<B> buckets;
    protected List<Bucket> extendedBuckets;
    protected Map<String, Bucket> bucketMap = null;

    public AggregateBase(AggregateDefinition definition, DocumentModel searchDocument) {
        assert (definition != null);
        this.definition = definition;
        this.searchDocument = searchDocument;
    }

    public String getId() {
        return this.definition.getId();
    }

    public String getType() {
        return this.definition.getType();
    }

    public String getField() {
        return this.definition.getDocumentField();
    }

    public Map<String, String> getProperties() {
        return this.definition.getProperties();
    }

    public List<AggregateRangeDefinition> getRanges() {
        return this.definition.getRanges();
    }

    public List<AggregateRangeDateDefinition> getDateRanges() {
        return this.definition.getDateRanges();
    }

    public List<String> getSelection() {
        if (this.selection == null) {
            PredicateFieldDefinition field = this.definition.getSearchField();
            if (this.searchDocument != null) {
                List value = null;
                Object resolvedProperties = this.searchDocument.getProperty(field.getSchema(), field.getName());
                if (resolvedProperties instanceof String[]) {
                    value = Arrays.asList((String[])resolvedProperties);
                } else if (resolvedProperties instanceof List) {
                    value = (List)this.searchDocument.getProperty(field.getSchema(), field.getName());
                }
                this.selection = value;
            }
            if (this.selection == null) {
                this.selection = Collections.emptyList();
            }
        }
        return this.selection;
    }

    public void setSelection(List<String> selection) {
        this.selection = selection;
    }

    public List<B> getBuckets() {
        return this.buckets;
    }

    public List<Bucket> getExtendedBuckets() {
        if (this.extendedBuckets == null) {
            this.extendedBuckets = new ArrayList<Bucket>();
            List<String> currentSelection = this.getSelection();
            if (currentSelection != null) {
                for (String s : currentSelection) {
                    if (this.hasBucket(s)) continue;
                    this.extendedBuckets.add(new MockBucket(s));
                }
            }
            this.extendedBuckets.addAll(this.buckets);
        }
        return this.extendedBuckets;
    }

    public void setBuckets(List<B> buckets) {
        this.buckets = buckets;
        this.bucketMap = null;
        this.extendedBuckets = null;
    }

    @JsonIgnore
    public DocumentModel getSearchDocument() {
        return this.searchDocument;
    }

    public String toString() {
        return String.format("Aggregate(%s, %s, %s, %s, %s)", this.getId(), this.getType(), this.getField(), this.getSelection() != null ? Arrays.toString(this.getSelection().toArray()) : null, this.buckets != null ? Arrays.toString(this.buckets.toArray()) : null);
    }

    public boolean hasBucket(String key) {
        return this.getBucketMap().containsKey(key);
    }

    public Bucket getBucket(String key) {
        return this.getBucketMap().get(key);
    }

    public Map<String, Bucket> getBucketMap() {
        if (this.bucketMap == null && this.getBuckets() != null) {
            this.bucketMap = new HashMap<String, Bucket>();
            for (Bucket b : this.getBuckets()) {
                this.bucketMap.put(b.getKey(), b);
            }
        }
        return this.bucketMap;
    }

    public void resetSelection() {
        PredicateFieldDefinition field = this.definition.getSearchField();
        if (this.searchDocument != null) {
            this.searchDocument.setProperty(field.getSchema(), field.getName(), null);
            this.selection = Collections.emptyList();
        }
    }
}

