/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql.model;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.query.sql.model.EsIdentifierList;
import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.Operand;

public class EsHint
implements Operand {
    private static final long serialVersionUID = 4590329982296853715L;
    public final String index;
    public final String analyzer;
    public final String operator;

    public EsHint(EsIdentifierList index, String analyzer, String operator) {
        this.index = index == null ? null : index.toString();
        this.analyzer = analyzer;
        this.operator = operator;
    }

    @Override
    public void accept(IVisitor visitor) {
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("/*+ES: ");
        if (this.index != null) {
            buf.append(String.format("INDEX(%s) ", this.index));
        }
        if (this.analyzer != null) {
            buf.append(String.format("ANALYZER(%s) ", this.analyzer));
        }
        if (this.operator != null) {
            buf.append(String.format("OPERATOR(%s) ", this.operator));
        }
        buf.append("*/");
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EsHint)) {
            return false;
        }
        return this.equals((EsHint)obj);
    }

    private boolean equals(EsHint other) {
        return StringUtils.equals((CharSequence)this.index, (CharSequence)other.index) && StringUtils.equals((CharSequence)this.analyzer, (CharSequence)other.analyzer) && StringUtils.equals((CharSequence)this.operator, (CharSequence)other.operator);
    }

    public String[] getIndex() {
        if (this.index == null) {
            return null;
        }
        return this.index.split(",");
    }
}

