/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql.model;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.query.sql.model.EsHint;
import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.Operand;

public class Reference
implements Operand {
    private static final long serialVersionUID = -1725102431543210430L;
    public final String name;
    public String originalName;
    public final String cast;
    public final EsHint esHint;
    public Object info;

    public Reference(String name) {
        this.name = name;
        this.cast = null;
        this.esHint = null;
    }

    public Reference(String name, String cast) {
        this.name = name;
        this.cast = cast;
        this.esHint = null;
    }

    public Reference(String name, String cast, EsHint hint) {
        this.name = name;
        this.cast = cast;
        this.esHint = hint;
    }

    public Reference(Reference other, String cast) {
        this.name = other.name;
        this.cast = cast;
        this.esHint = null;
    }

    public Reference(Reference other, EsHint hint) {
        this.name = other.name;
        this.cast = null;
        this.esHint = hint;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitReference(this);
    }

    public void setInfo(Object info) {
        this.info = info;
    }

    public Object getInfo() {
        return this.info;
    }

    public String toString() {
        if (this.cast != null) {
            return this.cast + '(' + this.name + ')';
        }
        if (this.esHint != null) {
            return this.esHint.toString() + " " + this.name;
        }
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Reference)) {
            return false;
        }
        return this.equals((Reference)obj);
    }

    private boolean equals(Reference other) {
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.cast != null || other.cast != null) {
            return StringUtils.equals((CharSequence)this.cast, (CharSequence)other.cast);
        }
        if (this.esHint != null) {
            return this.esHint.equals((Object)other.esHint);
        }
        return other.esHint == null;
    }

    public int hashCode() {
        int result = 31 + (this.cast == null ? 0 : this.cast.hashCode()) + (this.esHint == null ? 0 : this.esHint.hashCode());
        return 31 * result + this.name.hashCode();
    }

    public boolean isPathReference() {
        return false;
    }
}

