/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.collections.core.adapter.Collection;
import org.nuxeo.ecm.collections.core.adapter.CollectionMember;
import org.nuxeo.ecm.collections.core.worker.DuplicateCollectionMemberWork;
import org.nuxeo.ecm.collections.core.worker.RemoveFromCollectionWork;
import org.nuxeo.ecm.collections.core.worker.RemovedCollectionMemberWork;
import org.nuxeo.ecm.collections.core.worker.RemovedCollectionWork;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.platform.web.common.locale.LocaleProvider;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class CollectionManagerImpl
extends DefaultComponent
implements CollectionManager {
    private static final String PERMISSION_ERROR_MESSAGE = "Privilege '%s' is not granted to '%s'";

    public static void disableEvents(DocumentModel doc) {
        doc.putContextData("disableDublinCoreListener", (Serializable)Boolean.valueOf(true));
        doc.putContextData("disableNotificationService", (Serializable)Boolean.valueOf(true));
        doc.putContextData("disableAuditLogger", (Serializable)Boolean.valueOf(true));
        doc.putContextData("DisableAutoCheckOut", (Serializable)Boolean.valueOf(true));
    }

    @Override
    public void addToCollection(final DocumentModel collection, final DocumentModel documentToBeAdded, CoreSession session) throws DocumentSecurityException {
        this.checkCanAddToCollection(collection, documentToBeAdded, session);
        final HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("collectionRef", (Serializable)collection.getRef());
        this.fireEvent(documentToBeAdded, session, "beforeAddedToCollection", props);
        Collection colAdapter = (Collection)collection.getAdapter(Collection.class);
        colAdapter.addDocument(documentToBeAdded.getId());
        collection.getCoreSession().saveDocument(colAdapter.getDocument());
        new UnrestrictedSessionRunner(session){

            public void run() {
                documentToBeAdded.addFacet("CollectionMember");
                CollectionManagerImpl.disableEvents(documentToBeAdded);
                CollectionMember docAdapter = (CollectionMember)documentToBeAdded.getAdapter(CollectionMember.class);
                docAdapter.addToCollection(collection.getId());
                DocumentModel addedDoc = this.session.saveDocument(docAdapter.getDocument());
                CollectionManagerImpl.this.fireEvent(addedDoc, this.session, "addedToCollection", props);
            }
        }.runUnrestricted();
    }

    @Override
    public void addToCollection(DocumentModel collection, List<DocumentModel> documentListToBeAdded, CoreSession session) {
        for (DocumentModel documentToBeAdded : documentListToBeAdded) {
            this.addToCollection(collection, documentToBeAdded, session);
        }
    }

    @Override
    public void addToNewCollection(String newTitle, String newDescription, DocumentModel documentToBeAdded, CoreSession session) {
        this.addToCollection(this.createCollection(newTitle, newDescription, documentToBeAdded, session), documentToBeAdded, session);
    }

    @Override
    public void addToNewCollection(String newTitle, String newDescription, List<DocumentModel> documentListToBeAdded, CoreSession session) {
        DocumentModel newCollection = this.createCollection(newTitle, newDescription, documentListToBeAdded.get(0), session);
        for (DocumentModel documentToBeAdded : documentListToBeAdded) {
            this.addToCollection(newCollection, documentToBeAdded, session);
        }
    }

    @Override
    public boolean canAddToCollection(DocumentModel collection, CoreSession session) {
        return this.isCollection(collection) && session.hasPermission(collection.getRef(), "WriteProperties");
    }

    @Override
    public boolean canManage(DocumentModel collection, CoreSession session) {
        return this.isCollection(collection) && session.hasPermission(collection.getRef(), "Everything");
    }

    public void checkCanAddToCollection(DocumentModel collection, DocumentModel documentToBeAdded, CoreSession session) {
        if (!this.isCollectable(documentToBeAdded)) {
            throw new IllegalArgumentException(String.format("Document %s is not collectable", documentToBeAdded.getTitle()));
        }
        this.checkCanCollectInCollection(collection, session);
    }

    protected void checkCanCollectInCollection(DocumentModel collection, CoreSession session) {
        if (!this.isCollection(collection)) {
            throw new IllegalArgumentException(String.format("Document %s is not a collection", collection.getTitle()));
        }
        if (!session.hasPermission(collection.getRef(), "WriteProperties")) {
            throw new DocumentSecurityException(String.format(PERMISSION_ERROR_MESSAGE, "ReadCanCollect", session.getPrincipal().getName()));
        }
    }

    protected DocumentModel createCollection(String newTitle, String newDescription, DocumentModel context, CoreSession session) {
        DocumentModel defaultCollections = this.getUserDefaultCollections(context, session);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("parentPath", defaultCollections.getPath().toString());
        options.put("documentModelId", newTitle);
        options.put("destinationName", newTitle);
        DocumentModel newCollection = session.createDocumentModel("Collection", options);
        PathSegmentService pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
        newCollection.setPathInfo(defaultCollections.getPath().toString(), pss.generatePathSegment(newTitle));
        newCollection.setPropertyValue("dc:title", (Serializable)((Object)newTitle));
        newCollection.setPropertyValue("dc:description", (Serializable)((Object)newDescription));
        return session.createDocument(newCollection);
    }

    protected DocumentModel createDefaultCollectionsRoot(CoreSession session, DocumentModel userWorkspace) {
        String title;
        DocumentModel doc = session.createDocumentModel(userWorkspace.getPath().toString(), "Collections", "Collections");
        try {
            title = I18NUtils.getMessageString((String)"messages", (String)"label.myCollections.title", (Object[])new Object[0], (Locale)this.getLocale(session));
        }
        catch (MissingResourceException e) {
            title = "label.myCollections.title";
        }
        doc.setPropertyValue("dc:title", (Serializable)((Object)title));
        doc.setPropertyValue("dc:description", (Serializable)((Object)""));
        return doc;
    }

    protected DocumentModel initDefaultCollectionsRoot(CoreSession session, DocumentModel collectionsRoot) {
        ACPImpl acp = new ACPImpl();
        ACE denyEverything = new ACE("Everyone", "Everything", false);
        ACE allowEverything = new ACE(session.getPrincipal().getName(), "Everything", true);
        ACLImpl acl = new ACLImpl();
        acl.setACEs(new ACE[]{allowEverything, denyEverything});
        acp.addACL((ACL)acl);
        collectionsRoot.setACP((ACP)acp, true);
        return collectionsRoot;
    }

    @Override
    public DocumentModel getUserDefaultCollections(DocumentModel context, CoreSession session) {
        UserWorkspaceService userWorkspaceService = (UserWorkspaceService)Framework.getService(UserWorkspaceService.class);
        DocumentModel userWorkspace = userWorkspaceService.getCurrentUserPersonalWorkspace(session, context);
        DocumentModel defaultCollectionsRoot = this.createDefaultCollectionsRoot(session, userWorkspace);
        return session.getOrCreateDocument(defaultCollectionsRoot, doc -> this.initDefaultCollectionsRoot(session, (DocumentModel)doc));
    }

    @Override
    public List<DocumentModel> getVisibleCollection(DocumentModel collectionMember, CoreSession session) {
        return this.getVisibleCollection(collectionMember, 100, session);
    }

    @Override
    public List<DocumentModel> getVisibleCollection(DocumentModel collectionMember, int maxResult, CoreSession session) {
        ArrayList<DocumentModel> result = new ArrayList<DocumentModel>();
        if (this.isCollected(collectionMember)) {
            CollectionMember collectionMemberAdapter = (CollectionMember)collectionMember.getAdapter(CollectionMember.class);
            List<String> collectionIds = collectionMemberAdapter.getCollectionIds();
            for (int i = 0; i < collectionIds.size() && result.size() < maxResult; ++i) {
                DocumentModel collection;
                String collectionId = collectionIds.get(i);
                IdRef documentRef = new IdRef(collectionId);
                if (!session.exists((DocumentRef)documentRef) || !session.hasPermission((DocumentRef)documentRef, "Read") || (collection = session.getDocument((DocumentRef)documentRef)).isTrashed() || collection.isVersion()) continue;
                result.add(collection);
            }
        }
        return result;
    }

    @Override
    public boolean hasVisibleCollection(DocumentModel collectionMember, CoreSession session) {
        CollectionMember collectionMemberAdapter = (CollectionMember)collectionMember.getAdapter(CollectionMember.class);
        List<String> collectionIds = collectionMemberAdapter.getCollectionIds();
        for (String collectionId : collectionIds) {
            IdRef documentRef = new IdRef(collectionId);
            if (!session.exists((DocumentRef)documentRef) || !session.hasPermission((DocumentRef)documentRef, "Read")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCollectable(DocumentModel doc) {
        return !doc.hasFacet("NotCollectionMember");
    }

    @Override
    public boolean isCollected(DocumentModel doc) {
        return doc.hasFacet("CollectionMember");
    }

    @Override
    public boolean isCollection(DocumentModel doc) {
        return doc.hasFacet("Collection");
    }

    @Override
    public boolean isInCollection(DocumentModel collection, DocumentModel document, CoreSession session) {
        if (this.isCollected(document)) {
            CollectionMember collectionMemberAdapter = (CollectionMember)document.getAdapter(CollectionMember.class);
            return collectionMemberAdapter.getCollectionIds().contains(collection.getId());
        }
        return false;
    }

    @Override
    public void processCopiedCollection(DocumentModel collection) {
        Collection collectionAdapter = (Collection)collection.getAdapter(Collection.class);
        List<String> documentIds = collectionAdapter.getCollectedDocumentIds();
        int i = 0;
        while (i < documentIds.size()) {
            int limit = (int)((long)i + 50L > (long)documentIds.size() ? (long)documentIds.size() : (long)i + 50L);
            DuplicateCollectionMemberWork work = new DuplicateCollectionMemberWork(collection.getRepositoryName(), collection.getId(), documentIds.subList(i, limit), i);
            WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
            workManager.schedule((Work)work, WorkManager.Scheduling.IF_NOT_SCHEDULED, true);
            i = limit;
        }
    }

    @Override
    public void processRemovedCollection(DocumentModel collection) {
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        RemovedCollectionWork work = new RemovedCollectionWork();
        work.setDocument(collection.getRepositoryName(), collection.getId());
        workManager.schedule((Work)work, WorkManager.Scheduling.IF_NOT_SCHEDULED, true);
    }

    @Override
    public void processRemovedCollectionMember(DocumentModel collectionMember) {
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        RemovedCollectionMemberWork work = new RemovedCollectionMemberWork();
        work.setDocument(collectionMember.getRepositoryName(), collectionMember.getId());
        workManager.schedule((Work)work, WorkManager.Scheduling.IF_NOT_SCHEDULED, true);
    }

    @Override
    public void processRestoredCollection(DocumentModel collection, DocumentModel version) {
        WorkManager workManager;
        AbstractWork work;
        int limit;
        TreeSet<String> collectionMemberIdsToBeRemoved = new TreeSet<String>(((Collection)collection.getAdapter(Collection.class)).getCollectedDocumentIds());
        collectionMemberIdsToBeRemoved.removeAll(((Collection)version.getAdapter(Collection.class)).getCollectedDocumentIds());
        TreeSet<String> collectionMemberIdsToBeAdded = new TreeSet<String>(((Collection)version.getAdapter(Collection.class)).getCollectedDocumentIds());
        collectionMemberIdsToBeAdded.removeAll(((Collection)collection.getAdapter(Collection.class)).getCollectedDocumentIds());
        int i = 0;
        while (i < collectionMemberIdsToBeRemoved.size()) {
            limit = (int)((long)i + 50L > (long)collectionMemberIdsToBeRemoved.size() ? (long)collectionMemberIdsToBeRemoved.size() : (long)i + 50L);
            work = new RemoveFromCollectionWork(collection.getRepositoryName(), collection.getId(), new ArrayList<String>(collectionMemberIdsToBeRemoved).subList(i, limit), i);
            workManager = (WorkManager)Framework.getService(WorkManager.class);
            workManager.schedule((Work)work, WorkManager.Scheduling.IF_NOT_SCHEDULED, true);
            i = limit;
        }
        i = 0;
        while (i < collectionMemberIdsToBeAdded.size()) {
            limit = (int)((long)i + 50L > (long)collectionMemberIdsToBeAdded.size() ? (long)collectionMemberIdsToBeAdded.size() : (long)i + 50L);
            work = new DuplicateCollectionMemberWork(collection.getRepositoryName(), collection.getId(), new ArrayList<String>(collectionMemberIdsToBeAdded).subList(i, limit), i);
            workManager = (WorkManager)Framework.getService(WorkManager.class);
            workManager.schedule((Work)work, WorkManager.Scheduling.IF_NOT_SCHEDULED, true);
            i = limit;
        }
    }

    @Override
    public void removeAllFromCollection(DocumentModel collection, List<DocumentModel> documentListToBeRemoved, CoreSession session) {
        for (DocumentModel documentToBeRemoved : documentListToBeRemoved) {
            this.removeFromCollection(collection, documentToBeRemoved, session);
        }
    }

    @Override
    public void removeFromCollection(final DocumentModel collection, final DocumentModel documentToBeRemoved, CoreSession session) {
        this.checkCanAddToCollection(collection, documentToBeRemoved, session);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("collectionRef", (Serializable)new IdRef(collection.getId()));
        this.fireEvent(documentToBeRemoved, session, "beforeRemovedFromCollection", props);
        Collection colAdapter = (Collection)collection.getAdapter(Collection.class);
        colAdapter.removeDocument(documentToBeRemoved.getId());
        collection.getCoreSession().saveDocument(colAdapter.getDocument());
        new UnrestrictedSessionRunner(session){

            public void run() {
                CollectionManagerImpl.this.doRemoveFromCollection(documentToBeRemoved, collection.getId(), this.session);
            }
        }.runUnrestricted();
    }

    @Override
    public void doRemoveFromCollection(DocumentModel documentToBeRemoved, String collectionId, CoreSession session) {
        CollectionManagerImpl.disableEvents(documentToBeRemoved);
        CollectionMember docAdapter = (CollectionMember)documentToBeRemoved.getAdapter(CollectionMember.class);
        docAdapter.removeFromCollection(collectionId);
        DocumentModel removedDoc = session.saveDocument(docAdapter.getDocument());
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("collectionRef", (Serializable)new IdRef(collectionId));
        this.fireEvent(removedDoc, session, "removedFromCollection", props);
    }

    @Override
    public DocumentModel createCollection(CoreSession session, String title, String description, String path) {
        DocumentModel newCollection;
        if (StringUtils.isEmpty((CharSequence)path)) {
            newCollection = this.createCollection(title, description, null, session);
        } else {
            if (!session.exists((DocumentRef)new PathRef(path))) {
                throw new NuxeoException(String.format("Path \"%s\" specified in parameter not found", path));
            }
            DocumentModel collectionModel = session.createDocumentModel(path, title, "Collection");
            collectionModel.setPropertyValue("dc:title", (Serializable)((Object)title));
            collectionModel.setPropertyValue("dc:description", (Serializable)((Object)description));
            newCollection = session.createDocument(collectionModel);
        }
        return newCollection;
    }

    protected Locale getLocale(CoreSession session) {
        Locale locale = ((LocaleProvider)Framework.getService(LocaleProvider.class)).getLocale(session);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return new Locale(locale.getLanguage());
    }

    protected void fireEvent(DocumentModel doc, CoreSession session, String eventName, Map<String, Serializable> props) {
        EventService eventService = (EventService)Framework.getService(EventService.class);
        DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), doc);
        ctx.setProperty("repositoryName", (Serializable)((Object)session.getRepositoryName()));
        ctx.setProperty("sessionId", (Serializable)((Object)session.getSessionId()));
        ctx.setProperty("category", (Serializable)((Object)"eventDocumentCategory"));
        ctx.setProperties(props);
        Event event = ctx.newEvent(eventName);
        eventService.fireEvent(event);
    }

    @Override
    public boolean moveMembers(CoreSession session, DocumentModel collection, DocumentModel member1, DocumentModel member2) {
        this.checkCanCollectInCollection(collection, session);
        Collection collectionAdapter = (Collection)collection.getAdapter(Collection.class);
        boolean result = collectionAdapter.moveMembers(member1.getId(), member2 != null ? member2.getId() : null);
        if (result) {
            session.saveDocument(collectionAdapter.getDocument());
        }
        return result;
    }
}

