/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core;

import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.collections.api.FavoritesManager;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.platform.web.common.locale.LocaleProvider;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class FavoritesManagerImpl
extends DefaultComponent
implements FavoritesManager {
    @Override
    public void addToFavorites(DocumentModel document, CoreSession session) {
        CollectionManager collectionManager = (CollectionManager)Framework.getService(CollectionManager.class);
        collectionManager.addToCollection(this.getFavorites(document, session), document, session);
    }

    @Override
    public boolean canAddToFavorites(DocumentModel document) {
        CollectionManager collectionManager = (CollectionManager)Framework.getService(CollectionManager.class);
        return collectionManager.isCollectable(document);
    }

    protected DocumentModel createFavorites(CoreSession session, DocumentModel userWorkspace) {
        DocumentModel doc = session.createDocumentModel(userWorkspace.getPath().toString(), "Favorites", "Favorites");
        String title = null;
        try {
            title = I18NUtils.getMessageString((String)"messages", (String)"label.myFavorites.title", (Object[])new Object[0], (Locale)this.getLocale(session));
        }
        catch (MissingResourceException e) {
            title = "Favorites";
        }
        doc.setPropertyValue("dc:title", (Serializable)((Object)title));
        doc.setPropertyValue("dc:description", (Serializable)((Object)""));
        return doc;
    }

    protected DocumentModel initCreateFavorites(CoreSession session, DocumentModel favorites) {
        ACPImpl acp = new ACPImpl();
        ACE denyEverything = new ACE("Everyone", "Everything", false);
        ACE allowEverything = new ACE(session.getPrincipal().getName(), "Everything", true);
        ACLImpl acl = new ACLImpl();
        acl.setACEs(new ACE[]{allowEverything, denyEverything});
        acp.addACL((ACL)acl);
        favorites.setACP((ACP)acp, true);
        return favorites;
    }

    @Override
    public DocumentModel getFavorites(DocumentModel context, CoreSession session) {
        UserWorkspaceService userWorkspaceService = (UserWorkspaceService)Framework.getService(UserWorkspaceService.class);
        DocumentModel userWorkspace = userWorkspaceService.getCurrentUserPersonalWorkspace(session, context);
        if (userWorkspace == null) {
            return null;
        }
        DocumentModel favorites = this.createFavorites(session, userWorkspace);
        return session.getOrCreateDocument(favorites, doc -> this.initCreateFavorites(session, (DocumentModel)doc));
    }

    protected Locale getLocale(CoreSession session) {
        Locale locale = null;
        locale = ((LocaleProvider)Framework.getService(LocaleProvider.class)).getLocale(session);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return new Locale(Locale.getDefault().getLanguage());
    }

    @Override
    public boolean isFavorite(DocumentModel document, CoreSession session) {
        CollectionManager collectionManager = (CollectionManager)Framework.getService(CollectionManager.class);
        return collectionManager.isInCollection(this.getFavorites(document, session), document, session);
    }

    @Override
    public void removeFromFavorites(DocumentModel document, CoreSession session) {
        CollectionManager collectionManager = (CollectionManager)Framework.getService(CollectionManager.class);
        collectionManager.removeFromCollection(this.getFavorites(document, session), document, session);
    }
}

