/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.adapter;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;

public class Collection {
    private static final Log log = LogFactory.getLog(Collection.class);
    protected DocumentModel document;

    public Collection(DocumentModel doc) {
        this.document = doc;
    }

    public List<String> getCollectedDocumentIds() {
        List collected = (List)((Object)this.document.getPropertyValue("collection:documentIds"));
        return collected;
    }

    public void addDocument(String documentId) {
        List<String> documentIds = this.getCollectedDocumentIds();
        if (!documentIds.contains(documentId)) {
            documentIds.add(documentId);
        }
        this.setDocumentIds(documentIds);
    }

    public void removeDocument(String documentId) {
        List<String> documentIds = this.getCollectedDocumentIds();
        if (!documentIds.remove(documentId)) {
            log.warn((Object)String.format("Element '%s' is not present in the specified collection.", documentId));
        }
        this.setDocumentIds(documentIds);
    }

    public void setDocumentIds(List<String> documentIds) {
        this.document.setPropertyValue("collection:documentIds", (Serializable)((Object)documentIds));
    }

    public DocumentModel getDocument() {
        return this.document;
    }

    public boolean moveMembers(String member1Id, String member2Id) {
        List<String> documentIds = this.getCollectedDocumentIds();
        int member1IdIndex = documentIds.indexOf(member1Id);
        if (member1IdIndex < 0) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)member2Id)) {
            documentIds.remove(member1IdIndex);
            documentIds.add(0, member1Id);
            this.setDocumentIds(documentIds);
            return true;
        }
        int member2IdIndex = documentIds.indexOf(member2Id);
        if (member2IdIndex < 0) {
            return false;
        }
        if (member1IdIndex == member2IdIndex) {
            return false;
        }
        if (member2IdIndex > member1IdIndex) {
            documentIds.remove(member1IdIndex);
            int newMember2IdIndex = documentIds.indexOf(member2Id);
            documentIds.add(newMember2IdIndex + 1, member1Id);
        } else {
            documentIds.remove(member2IdIndex);
            int newMember1IdIndex = documentIds.indexOf(member1Id);
            documentIds.add(newMember1IdIndex + 1, member2Id);
        }
        this.setDocumentIds(documentIds);
        return true;
    }

    public int size() {
        return this.getCollectedDocumentIds().size();
    }
}

