/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.adapter;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;

public class CollectionMember {
    private static final Log log = LogFactory.getLog(CollectionMember.class);
    protected DocumentModel document;

    public CollectionMember(DocumentModel doc) {
        this.document = doc;
    }

    public void addToCollection(String collectionId) {
        List<String> collectionIds = this.getCollectionIds();
        if (!collectionIds.contains(collectionId)) {
            collectionIds.add(collectionId);
        }
        this.setCollectionIds(collectionIds);
    }

    public void setCollectionIds(List<String> collectionIds) {
        this.document.setPropertyValue("collectionMember:collectionIds", (Serializable)((Object)collectionIds));
    }

    public List<String> getCollectionIds() {
        List collectionIds = (List)((Object)this.document.getPropertyValue("collectionMember:collectionIds"));
        return collectionIds;
    }

    public DocumentModel getDocument() {
        return this.document;
    }

    public void removeFromCollection(String documentId) {
        List<String> collectionIds = this.getCollectionIds();
        if (!collectionIds.remove(documentId)) {
            log.warn((Object)String.format("Element '%s' is not present in the specified collection.", documentId));
        }
        this.setCollectionIds(collectionIds);
    }
}

