/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.migration;

public interface MigrationService {
    public MigrationStatus getStatus(String var1);

    public void runStep(String var1, String var2);

    public static class MigrationStatus {
        protected final String state;
        protected final String step;
        protected final long startTime;
        protected final long pingTime;
        protected final String progressMessage;
        protected final long progressNum;
        protected final long progressTotal;

        public MigrationStatus(String state) {
            this.state = state;
            this.step = null;
            this.startTime = 0L;
            this.pingTime = 0L;
            this.progressMessage = null;
            this.progressNum = 0L;
            this.progressTotal = 0L;
        }

        public MigrationStatus(String step, long startTime, long pingTime, String progressMessage, long progressNum, long progressTotal) {
            this.state = null;
            this.step = step;
            this.startTime = startTime;
            this.pingTime = pingTime;
            this.progressMessage = progressMessage;
            this.progressNum = progressNum;
            this.progressTotal = progressTotal;
        }

        public boolean isRunning() {
            return this.state == null;
        }

        public String getState() {
            return this.state;
        }

        public String getStep() {
            return this.step;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getPingTime() {
            return this.pingTime;
        }

        public String getProgressMessage() {
            return this.progressMessage;
        }

        public long getProgressNum() {
            return this.progressNum;
        }

        public long getProgressTotal() {
            return this.progressTotal;
        }
    }

    public static interface MigrationContext {
        public void reportProgress(String var1, long var2, long var4);

        public void requestShutdown();

        public boolean isShutdownRequested();
    }

    public static interface Migrator {
        public void run(MigrationContext var1);
    }

    public static interface StatusChangeNotifier {
        public void notifyStatusChange();
    }
}

