/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.migration;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;
import org.nuxeo.runtime.migration.MigrationDescriptor;
import org.nuxeo.runtime.migration.MigrationService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;
import org.nuxeo.runtime.pubsub.AbstractPubSubBroker;
import org.nuxeo.runtime.pubsub.SerializableMessage;

public class MigrationServiceImpl
extends DefaultComponent
implements MigrationService {
    static final Log log = LogFactory.getLog(MigrationServiceImpl.class);
    public static final String KEYVALUE_STORE_NAME = "migration";
    public static final String CONFIG_XP = "configuration";
    public static final String LOCK = ":lock";
    public static final String STEP = ":step";
    public static final String START_TIME = ":starttime";
    public static final String PING_TIME = ":pingtime";
    public static final String PROGRESS_MESSAGE = ":message";
    public static final String PROGRESS_NUM = ":num";
    public static final String PROGRESS_TOTAL = ":total";
    public static final long WRITE_LOCK_TTL = 10L;
    public static final String MIGRATION_INVAL_PUBSUB_TOPIC = "migrationinval";
    public static final String CLUSTERING_ENABLED_PROP = "repository.clustering.enabled";
    public static final String NODE_ID_PROP = "repository.clustering.id";
    protected static final Random RANDOM = new Random();
    protected final MigrationRegistry registry = new MigrationRegistry();
    protected MigrationThreadPoolExecutor executor;
    protected MigrationInvalidator invalidator;

    protected static KeyValueStore getKeyValueStore() {
        KeyValueService service = (KeyValueService)Framework.getService(KeyValueService.class);
        Objects.requireNonNull(service, "Missing KeyValueService");
        return service.getKeyValueStore(KEYVALUE_STORE_NAME);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        switch (extensionPoint) {
            case "configuration": {
                this.registerMigrationDescriptor((MigrationDescriptor)contribution);
                break;
            }
            default: {
                throw new RuntimeException("Unknown extension point: " + extensionPoint);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        switch (extensionPoint) {
            case "configuration": {
                this.unregisterMigrationDescriptor((MigrationDescriptor)contribution);
            }
        }
    }

    public void registerMigrationDescriptor(MigrationDescriptor descriptor) {
        this.registry.addContribution(descriptor);
        log.info((Object)("Registered migration: " + descriptor.id));
    }

    public void unregisterMigrationDescriptor(MigrationDescriptor descriptor) {
        this.registry.removeContribution(descriptor);
        log.info((Object)("Unregistered migration: " + descriptor.id));
    }

    public Map<String, MigrationDescriptor> getMigrationDescriptors() {
        return this.registry.getMigrationDescriptors();
    }

    public int getApplicationStartedOrder() {
        return -490;
    }

    public void start(ComponentContext context) {
        if (Framework.isBooleanPropertyTrue((String)CLUSTERING_ENABLED_PROP)) {
            String nodeId = Framework.getProperty((String)NODE_ID_PROP);
            if (StringUtils.isBlank((CharSequence)nodeId)) {
                nodeId = String.valueOf(RANDOM.nextLong());
                log.warn((Object)("Missing cluster node id configuration, please define it explicitly (usually through repository.clustering.id). Using random cluster node id instead: " + nodeId));
            } else {
                nodeId = nodeId.trim();
            }
            this.invalidator = new MigrationInvalidator();
            this.invalidator.initialize(MIGRATION_INVAL_PUBSUB_TOPIC, nodeId);
            log.info((Object)("Registered migration invalidator for node: " + nodeId));
        } else {
            log.info((Object)"Not registering a migration invalidator because clustering is not enabled");
        }
        this.executor = new MigrationThreadPoolExecutor();
        Framework.getRuntime().getComponentManager().addListener(new ComponentManager.Listener(){

            public void beforeStop(ComponentManager mgr, boolean isStandby) {
                MigrationServiceImpl.this.executor.requestShutdown();
            }

            public void afterStop(ComponentManager mgr, boolean isStandby) {
                Framework.getRuntime().getComponentManager().removeListener((ComponentManager.Listener)this);
            }
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.executor.shutdownNow();
        this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        this.executor = null;
    }

    @Override
    public MigrationService.MigrationStatus getStatus(String id) {
        MigrationDescriptor descr = this.registry.getMigrationDescriptor(id);
        if (descr == null) {
            return null;
        }
        KeyValueStore kv = MigrationServiceImpl.getKeyValueStore();
        String state = kv.getString(id);
        if (state != null) {
            return new MigrationService.MigrationStatus(state);
        }
        String step = kv.getString(id + STEP);
        if (step == null) {
            state = descr.getDefaultState();
            return new MigrationService.MigrationStatus(state);
        }
        long startTime = Long.parseLong(kv.getString(id + START_TIME));
        long pingTime = Long.parseLong(kv.getString(id + PING_TIME));
        String progressMessage = kv.getString(id + PROGRESS_MESSAGE);
        long progressNum = Long.parseLong(kv.getString(id + PROGRESS_NUM));
        long progressTotal = Long.parseLong(kv.getString(id + PROGRESS_TOTAL));
        if (progressMessage == null) {
            progressMessage = "";
        }
        return new MigrationService.MigrationStatus(step, startTime, pingTime, progressMessage, progressNum, progressTotal);
    }

    @Override
    public void runStep(String id, String step) {
        MigrationService.Migrator migrator;
        MigrationDescriptor descr = this.registry.getMigrationDescriptor(id);
        if (descr == null) {
            throw new IllegalArgumentException("Unknown migration: " + id);
        }
        MigrationDescriptor.MigrationStepDescriptor stepDescr = descr.getSteps().get(step);
        if (stepDescr == null) {
            throw new IllegalArgumentException("Unknown step: " + step + " for migration: " + id);
        }
        Class<?> klass = stepDescr.getKlass();
        if (!MigrationService.Migrator.class.isAssignableFrom(klass)) {
            throw new RuntimeException("Invalid class not implementing Migrator: " + klass.getName() + " for step: " + step + " for migration: " + id);
        }
        try {
            migrator = (MigrationService.Migrator)klass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        MigrationService.StatusChangeNotifier notifier = this.getStatusChangeNotifier(descr);
        ProgressReporter progressReporter = new ProgressReporter(id);
        this.atomic(id, kv -> {
            String state = kv.getString(id);
            String currentStep = kv.getString(id + STEP);
            if (state == null && currentStep == null) {
                state = descr.getDefaultState();
                if (!descr.getStates().containsKey(state)) {
                    throw new RuntimeException("Invalid default state: " + state + " for migration: " + id);
                }
            } else if (state == null) {
                throw new IllegalArgumentException("Migration: " + id + " already running step: " + currentStep);
            }
            if (!descr.getStates().containsKey(state)) {
                throw new RuntimeException("Invalid current state: " + state + " for migration: " + id);
            }
            if (!stepDescr.getFromState().equals(state)) {
                throw new IllegalArgumentException("Invalid step: " + step + " for migration: " + id + " in state: " + state);
            }
            String time = String.valueOf(System.currentTimeMillis());
            kv.put(id + STEP, step);
            kv.put(id + START_TIME, time);
            progressReporter.reportProgress("", 0L, -1L, true);
            kv.put(id, (String)null);
        });
        notifier.notifyStatusChange();
        Consumer<MigrationService.MigrationContext> migration = migrationContext -> {
            Thread.currentThread().setName("Nuxeo-Migrator-" + id);
            migrator.run((MigrationService.MigrationContext)migrationContext);
        };
        BiConsumer<MigrationService.MigrationContext, Throwable> afterMigration = (migrationContext, t) -> {
            if (t != null) {
                log.error((Object)("Exception during execution of step: " + step + " for migration: " + id), t);
            }
            String state = t != null || migrationContext.isShutdownRequested() ? stepDescr.getFromState() : stepDescr.getToState();
            this.atomic(id, kv -> {
                kv.put(id, state);
                kv.put(id + STEP, (String)null);
                kv.put(id + START_TIME, (String)null);
                progressReporter.reportProgress(null, -2L, -2L, false);
            });
            notifier.notifyStatusChange();
        };
        this.executor.execute(new MigratorWithContext(migration, progressReporter, afterMigration));
    }

    protected MigrationService.StatusChangeNotifier getStatusChangeNotifier(String id) {
        MigrationDescriptor descr = this.registry.getMigrationDescriptor(id);
        return descr == null ? null : this.getStatusChangeNotifier(descr);
    }

    protected MigrationService.StatusChangeNotifier getStatusChangeNotifier(MigrationDescriptor descr) {
        MigrationService.StatusChangeNotifier notifier;
        Class<?> klass = descr.getStatusChangeNotifierClass();
        if (klass == null) {
            throw new RuntimeException("Missing statusChangeNotifier for migration: " + descr.getId());
        }
        if (!MigrationService.StatusChangeNotifier.class.isAssignableFrom(klass)) {
            throw new RuntimeException("Invalid class not implementing StatusChangeNotifier: " + klass.getName() + " for migration: " + descr.getId());
        }
        try {
            notifier = (MigrationService.StatusChangeNotifier)klass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return notifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void atomic(String id, Consumer<KeyValueStore> consumer) {
        KeyValueStore kv = MigrationServiceImpl.getKeyValueStore();
        String nodeid = Framework.getProperty((String)NODE_ID_PROP);
        for (int i = 0; i < 5; ++i) {
            String value = Instant.now() + " node=" + nodeid;
            if (kv.compareAndSet(id + LOCK, null, value, 10L)) {
                try {
                    consumer.accept(kv);
                    return;
                }
                finally {
                    kv.put(id + LOCK, (String)null);
                }
            }
            try {
                Thread.sleep((long)(Math.random() * 100.0 * (double)i));
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        String currentLock = kv.getString(id + LOCK);
        throw new RuntimeException("Cannot lock for write migration: " + id + ", already locked: " + currentLock);
    }

    protected static class MigrationThreadPoolExecutor
    extends ThreadPoolExecutor {
        protected final List<MigratorWithContext> runnables = new CopyOnWriteArrayList<MigratorWithContext>();

        public MigrationThreadPoolExecutor() {
            super(0, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        }

        @Override
        protected void beforeExecute(Thread thread, Runnable runnable) {
            this.runnables.add((MigratorWithContext)runnable);
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable t) {
            this.runnables.remove(runnable);
            ((MigratorWithContext)runnable).afterMigration(t);
        }

        public void requestShutdown() {
            this.runnables.forEach(migratorWithContext -> migratorWithContext.requestShutdown());
        }
    }

    protected static class MigratorWithContext
    implements Runnable {
        protected final Consumer<MigrationService.MigrationContext> migration;
        protected final MigrationService.MigrationContext migrationContext;
        protected final BiConsumer<MigrationService.MigrationContext, Throwable> afterMigration;

        public MigratorWithContext(Consumer<MigrationService.MigrationContext> migration, ProgressReporter progressReporter, BiConsumer<MigrationService.MigrationContext, Throwable> afterMigration) {
            this.migration = migration;
            this.migrationContext = new MigrationContextImpl(progressReporter);
            this.afterMigration = afterMigration;
        }

        @Override
        public void run() {
            this.migration.accept(this.migrationContext);
        }

        public void afterMigration(Throwable t) {
            this.afterMigration.accept(this.migrationContext, t);
        }

        public void requestShutdown() {
            this.migrationContext.requestShutdown();
        }
    }

    protected static class MigrationContextImpl
    implements MigrationService.MigrationContext {
        protected final ProgressReporter progressReporter;
        protected volatile boolean shutdown;

        public MigrationContextImpl(ProgressReporter progressReporter) {
            this.progressReporter = progressReporter;
        }

        @Override
        public void reportProgress(String message, long num, long total) {
            this.progressReporter.reportProgress(message, num, total, true);
        }

        @Override
        public void requestShutdown() {
            this.shutdown = true;
        }

        @Override
        public boolean isShutdownRequested() {
            return this.shutdown || Thread.currentThread().isInterrupted();
        }
    }

    protected static class ProgressReporter {
        protected final String id;

        public ProgressReporter(String id) {
            this.id = id;
        }

        public void reportProgress(String message, long num, long total, boolean ping) {
            KeyValueStore keyValueStore = MigrationServiceImpl.getKeyValueStore();
            keyValueStore.put(this.id + MigrationServiceImpl.PROGRESS_MESSAGE, message);
            keyValueStore.put(this.id + MigrationServiceImpl.PROGRESS_NUM, num == -2L ? null : String.valueOf(num));
            keyValueStore.put(this.id + MigrationServiceImpl.PROGRESS_TOTAL, total == -2L ? null : String.valueOf(total));
            keyValueStore.put(this.id + MigrationServiceImpl.PING_TIME, ping ? String.valueOf(System.currentTimeMillis()) : null);
        }
    }

    public class MigrationInvalidator
    extends AbstractPubSubBroker<MigrationInvalidation> {
        public MigrationInvalidation deserialize(InputStream in) throws IOException {
            return MigrationInvalidation.deserialize(in);
        }

        public void receivedMessage(MigrationInvalidation message) {
            String id = message.id;
            MigrationService.StatusChangeNotifier notifier = MigrationServiceImpl.this.getStatusChangeNotifier(id);
            if (notifier == null) {
                log.error((Object)("Unknown migration id received in invalidation: " + id));
                return;
            }
            notifier.notifyStatusChange();
        }
    }

    public static class MigrationInvalidation
    implements SerializableMessage {
        private static final long serialVersionUID = 1L;
        public final String id;

        public MigrationInvalidation(String id) {
            this.id = id;
        }

        public void serialize(OutputStream out) throws IOException {
            IOUtils.write((String)this.id, (OutputStream)out, (Charset)StandardCharsets.UTF_8);
        }

        public static MigrationInvalidation deserialize(InputStream in) throws IOException {
            String id = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            return new MigrationInvalidation(id);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.id + ")";
        }
    }

    public static class MigrationRegistry
    extends SimpleContributionRegistry<MigrationDescriptor> {
        public String getContributionId(MigrationDescriptor contrib) {
            return contrib.id;
        }

        public MigrationDescriptor getMigrationDescriptor(String id) {
            return (MigrationDescriptor)this.getCurrentContribution(id);
        }

        public Map<String, MigrationDescriptor> getMigrationDescriptors() {
            return this.currentContribs;
        }

        public boolean isSupportingMerge() {
            return true;
        }

        public MigrationDescriptor clone(MigrationDescriptor orig) {
            return new MigrationDescriptor(orig);
        }

        public void merge(MigrationDescriptor src, MigrationDescriptor dst) {
            dst.merge(src);
        }
    }
}

