/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.styling.service.descriptors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.theme.styling.service.descriptors.FlavorPresets;
import org.nuxeo.theme.styling.service.descriptors.IconDescriptor;
import org.nuxeo.theme.styling.service.descriptors.LogoDescriptor;
import org.nuxeo.theme.styling.service.descriptors.PalettePreview;
import org.nuxeo.theme.styling.service.descriptors.SassImport;

@XObject(value="flavor")
public class FlavorDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XNode(value="@name")
    String name;
    @XNode(value="label")
    String label;
    @XNode(value="@extends")
    String extendsFlavor;
    @XNode(value="logo")
    LogoDescriptor logo;
    @XNode(value="palettePreview")
    PalettePreview palettePreview;
    @XNode(value="sass@append")
    boolean appendSass;
    @XNode(value="presetsList@append")
    boolean appendPresets;
    @XNodeList(value="sass/import", type=ArrayList.class, componentType=SassImport.class)
    List<SassImport> sassImports;
    @XNodeList(value="presetsList/presets", type=ArrayList.class, componentType=FlavorPresets.class)
    List<FlavorPresets> presets;
    @XNodeList(value="links/icon", type=ArrayList.class, componentType=IconDescriptor.class)
    List<IconDescriptor> favicons;

    public FlavorDescriptor clone() {
        List<IconDescriptor> favicons;
        PalettePreview pp;
        FlavorDescriptor clone = new FlavorDescriptor();
        clone.setName(this.getName());
        clone.setLabel(this.getLabel());
        LogoDescriptor logo = this.getLogo();
        if (logo != null) {
            clone.setLogo(logo.clone());
        }
        if ((pp = this.getPalettePreview()) != null) {
            clone.setPalettePreview(pp.clone());
        }
        clone.setExtendsFlavor(this.getExtendsFlavor());
        clone.setAppendPresets(this.getAppendPresets());
        List<FlavorPresets> presets = this.getPresets();
        if (presets != null) {
            ArrayList<FlavorPresets> newPresets = new ArrayList<FlavorPresets>();
            for (FlavorPresets flavorPresets : presets) {
                newPresets.add(flavorPresets.clone());
            }
            clone.setPresets(newPresets);
        }
        clone.setAppendSass(this.getAppendSass());
        List<SassImport> sassVariables = this.getSassImports();
        if (sassVariables != null) {
            ArrayList<SassImport> cSassVariables = new ArrayList<SassImport>();
            for (SassImport var : sassVariables) {
                cSassVariables.add(var.clone());
            }
            clone.setSassImports(cSassVariables);
        }
        if ((favicons = this.getFavicons()) != null) {
            ArrayList<IconDescriptor> arrayList = new ArrayList<IconDescriptor>();
            for (IconDescriptor icon : favicons) {
                arrayList.add(icon.clone());
            }
            clone.setFavicons(arrayList);
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FlavorDescriptor)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        FlavorDescriptor f = (FlavorDescriptor)obj;
        return new EqualsBuilder().append((Object)this.name, (Object)f.name).append((Object)this.label, (Object)f.label).append((Object)this.extendsFlavor, (Object)f.extendsFlavor).append((Object)this.logo, (Object)f.logo).append((Object)this.palettePreview, (Object)f.palettePreview).append(this.appendPresets, f.appendPresets).append(this.presets, f.presets).append(this.appendSass, f.appendSass).append(this.sassImports, f.sassImports).append(this.favicons, f.favicons).isEquals();
    }

    public boolean getAppendPresets() {
        return this.appendPresets;
    }

    public boolean getAppendSass() {
        return this.appendSass;
    }

    public String getExtendsFlavor() {
        return this.extendsFlavor;
    }

    public List<IconDescriptor> getFavicons() {
        return this.favicons;
    }

    public String getLabel() {
        return this.label;
    }

    public LogoDescriptor getLogo() {
        return this.logo;
    }

    public String getName() {
        return this.name;
    }

    public PalettePreview getPalettePreview() {
        return this.palettePreview;
    }

    public List<FlavorPresets> getPresets() {
        return this.presets;
    }

    public List<SassImport> getSassImports() {
        return this.sassImports;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appendPresets ? 1231 : 1237);
        result = 31 * result + (this.appendSass ? 1231 : 1237);
        result = 31 * result + (this.extendsFlavor == null ? 0 : this.extendsFlavor.hashCode());
        result = 31 * result + (this.favicons == null ? 0 : this.favicons.hashCode());
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.logo == null ? 0 : this.logo.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.palettePreview == null ? 0 : this.palettePreview.hashCode());
        result = 31 * result + (this.presets == null ? 0 : this.presets.hashCode());
        result = 31 * result + (this.sassImports == null ? 0 : this.sassImports.hashCode());
        return result;
    }

    public void merge(FlavorDescriptor src) {
        List<IconDescriptor> newFavicons;
        List<SassImport> newSassImports;
        List<FlavorPresets> newPresets;
        PalettePreview pp;
        LogoDescriptor logo;
        String newLabel;
        String newExtend = src.getExtendsFlavor();
        if (newExtend != null) {
            this.setExtendsFlavor(newExtend);
        }
        if ((newLabel = src.getLabel()) != null) {
            this.setLabel(newLabel);
        }
        if ((logo = src.getLogo()) != null) {
            LogoDescriptor newLogo = this.getLogo();
            if (newLogo == null) {
                newLogo = logo.clone();
            } else {
                if (logo.getHeight() != null) {
                    newLogo.setHeight(logo.getHeight());
                }
                if (logo.getWidth() != null) {
                    newLogo.setWidth(logo.getWidth());
                }
                if (logo.getTitle() != null) {
                    newLogo.setTitle(logo.getTitle());
                }
                if (logo.getPath() != null) {
                    newLogo.setPath(logo.getPath());
                }
            }
            this.setLogo(newLogo);
        }
        if ((pp = src.getPalettePreview()) != null) {
            this.setPalettePreview(pp);
        }
        if ((newPresets = src.getPresets()) != null) {
            List<FlavorPresets> oldPresets;
            boolean keepOld;
            ArrayList<FlavorPresets> merged = new ArrayList<FlavorPresets>();
            merged.addAll(newPresets);
            boolean bl = keepOld = src.getAppendPresets() || newPresets.isEmpty() && !src.getAppendPresets();
            if (keepOld && (oldPresets = this.getPresets()) != null) {
                merged.addAll(0, oldPresets);
            }
            this.setPresets(merged);
        }
        if ((newSassImports = src.getSassImports()) != null) {
            List<SassImport> oldSassImports;
            boolean keepOld;
            ArrayList<SassImport> merged = new ArrayList<SassImport>();
            merged.addAll(newSassImports);
            boolean bl = keepOld = src.getAppendSass() || newSassImports.isEmpty() && !src.getAppendSass();
            if (keepOld && (oldSassImports = this.getSassImports()) != null) {
                merged.addAll(0, oldSassImports);
            }
            this.setSassImports(merged);
        }
        if ((newFavicons = src.getFavicons()) != null && !newFavicons.isEmpty()) {
            this.setFavicons(newFavicons);
        }
    }

    public void setAppendPresets(boolean appendPresets) {
        this.appendPresets = appendPresets;
    }

    public void setAppendSass(boolean appendSass) {
        this.appendSass = appendSass;
    }

    public void setExtendsFlavor(String extendsFlavor) {
        this.extendsFlavor = extendsFlavor;
    }

    public void setFavicons(List<IconDescriptor> favicons) {
        this.favicons = favicons;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLogo(LogoDescriptor logo) {
        this.logo = logo;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPalettePreview(PalettePreview palettePreview) {
        this.palettePreview = palettePreview;
    }

    public void setPresets(List<FlavorPresets> presets) {
        this.presets = presets;
    }

    public void setSassImports(List<SassImport> sassImports) {
        this.sassImports = sassImports;
    }
}

