/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import java.lang.reflect.Array;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.pool.ClassLookup;
import org.jetbrains.annotations.NotNull;

public class ClassAliasPool
implements ClassLookup {
    public static final ClassAliasPool CLASS_ALIASES = new ClassAliasPool(null).defaultAliases();
    static final ThreadLocal<CAPKey> CAP_KEY_TL = ThreadLocal.withInitial(() -> new CAPKey(null));
    private final ClassLookup parent;
    private final ClassLoader classLoader;
    private final Map<CAPKey, Class> stringClassMap = new ConcurrentHashMap<CAPKey, Class>();
    private final Map<CAPKey, Class> stringClassMap2 = new ConcurrentHashMap<CAPKey, Class>();
    private final Map<Class, String> classStringMap = new ConcurrentHashMap<Class, String>();

    ClassAliasPool(ClassLookup parent, ClassLoader classLoader) {
        this.parent = parent;
        this.classLoader = classLoader;
    }

    ClassAliasPool(ClassLookup parent) {
        this.parent = parent;
        this.classLoader = this.getClass().getClassLoader();
    }

    @NotNull
    private ClassAliasPool defaultAliases() {
        this.addAlias(Set.class, "!set");
        this.addAlias(SortedSet.class, "!oset");
        this.addAlias(List.class, "!seq");
        this.addAlias(Map.class, "!map");
        this.addAlias(SortedMap.class, "!omap");
        this.addAlias(String.class, "String, !str");
        this.addAlias(CharSequence.class);
        this.addAlias(Byte.class, "byte, int8");
        this.addAlias(Short.class, "short, int16");
        this.addAlias(Character.class, "Char");
        this.addAlias(Integer.class, "int, int32");
        this.addAlias(Long.class, "long, int64");
        this.addAlias(Float.class, "Float32");
        this.addAlias(Double.class, "Float64");
        this.addAlias(LocalDate.class, "Date");
        this.addAlias(LocalDateTime.class, "DateTime");
        this.addAlias(LocalTime.class, "Time");
        this.addAlias(ZonedDateTime.class, "ZonedDateTime");
        this.addAlias(TimeUnit.class, "TimeUnit");
        this.addAlias(String[].class, "String[]");
        for (Class prim : new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
            this.addAlias(Array.newInstance(prim, 0).getClass(), prim.getName() + "[]");
        }
        this.addAlias(Class.class, "type");
        this.addAlias(Void.TYPE, "!null");
        return this;
    }

    public void clean() {
        this.clean(this.stringClassMap.values());
        this.clean(this.stringClassMap2.values());
        this.clean(this.classStringMap.keySet());
    }

    private void clean(@NotNull Iterable<Class> coll) {
        ClassLoader classLoader2 = ClassAliasPool.class.getClassLoader();
        Iterator<Class> iter = coll.iterator();
        while (iter.hasNext()) {
            Class clazz = iter.next();
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null || classLoader == classLoader2) continue;
            iter.remove();
        }
    }

    @Override
    public Class forName(@NotNull CharSequence name) throws ClassNotFoundException {
        Objects.requireNonNull(name);
        CAPKey key = CAP_KEY_TL.get();
        key.value = name;
        Class clazz = this.stringClassMap.get(key);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.stringClassMap2.get(key);
        if (clazz != null) {
            return clazz;
        }
        return this.forName0(key);
    }

    private synchronized Class forName0(@NotNull CAPKey key) {
        Class<?> clazz = this.stringClassMap2.get(key);
        if (clazz != null) {
            return clazz;
        }
        String name0 = key.toString();
        CAPKey key2 = new CAPKey(name0);
        try {
            clazz = Class.forName(name0, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            if (this.parent != null) {
                try {
                    return this.parent.forName(name0);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw Jvm.rethrow(e);
        }
        this.stringClassMap2.put(key2, clazz);
        return clazz;
    }

    @Override
    public String nameFor(Class clazz) {
        String name = this.classStringMap.get(clazz);
        return name == null ? (this.parent == null ? this.nameFor0(clazz) : this.parent.nameFor(clazz)) : name;
    }

    private String nameFor0(Class clazz) {
        Class clazz2;
        if (Enum.class.isAssignableFrom(clazz) && (clazz2 = clazz.getSuperclass()) != null && clazz2 != Enum.class && Enum.class.isAssignableFrom(clazz2)) {
            String alias = this.classStringMap.get(clazz2);
            if (alias != null) {
                this.classStringMap.putIfAbsent(clazz, alias);
                return alias;
            }
            return clazz2.getName();
        }
        return clazz.getName();
    }

    @Override
    public void addAlias(Class ... classes) {
        for (Class clazz : classes) {
            this.stringClassMap.putIfAbsent(new CAPKey(clazz.getName()), clazz);
            this.stringClassMap2.putIfAbsent(new CAPKey(clazz.getSimpleName()), clazz);
            this.stringClassMap2.putIfAbsent(new CAPKey(this.toCamelCase(clazz.getSimpleName())), clazz);
            this.classStringMap.computeIfAbsent(clazz, Class::getSimpleName);
        }
    }

    @NotNull
    private String toCamelCase(@NotNull String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    @Override
    public void addAlias(Class clazz, @NotNull String names) {
        for (String name : names.split(", ?")) {
            this.stringClassMap.put(new CAPKey(name), clazz);
            this.stringClassMap2.putIfAbsent(new CAPKey(this.toCamelCase(name)), clazz);
            this.classStringMap.putIfAbsent(clazz, name);
            this.addAlias(clazz);
        }
    }

    static class CAPKey
    implements CharSequence {
        CharSequence value;

        CAPKey(String name) {
            this.value = name;
        }

        @Override
        public int length() {
            return this.value.length();
        }

        @Override
        public char charAt(int index) {
            return this.value.charAt(index);
        }

        @Override
        @NotNull
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String toString() {
            return this.value.toString();
        }

        public int hashCode() {
            if (this.value instanceof String) {
                return this.value.hashCode();
            }
            int h = 0;
            for (int i = 0; i < this.value.length(); ++i) {
                h = 31 * h + this.charAt(i);
            }
            return h;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CharSequence)) {
                return false;
            }
            CharSequence cs = (CharSequence)obj;
            if (this.length() != cs.length()) {
                return false;
            }
            for (int i = 0; i < this.length(); ++i) {
                if (this.charAt(i) == cs.charAt(i)) continue;
                return false;
            }
            return true;
        }
    }
}

