/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.batch;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.core.util.ComplexTypeJSONDecoder;
import org.nuxeo.ecm.automation.core.util.JSONBlobDecoder;
import org.nuxeo.ecm.automation.server.AutomationServer;
import org.nuxeo.ecm.automation.server.RestBinding;
import org.nuxeo.ecm.automation.server.jaxrs.batch.Batch;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchFileEntry;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchHandler;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManager;
import org.nuxeo.ecm.automation.server.jaxrs.batch.JSONBatchBlobDecoder;
import org.nuxeo.ecm.automation.server.jaxrs.batch.handler.BatchHandlerDescriptor;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class BatchManagerComponent
extends DefaultComponent
implements BatchManager {
    protected static final Log log = LogFactory.getLog(BatchManagerComponent.class);
    protected static final String TRANSIENT_STORE_NAME = "BatchManagerCache";
    public static final String CLIENT_BATCH_ID_FLAG = "allowClientGeneratedBatchId";
    public static final String DEFAULT_BATCH_HANDLER = "default";
    public static final String EP_BATCH_HANDLER = "handlers";
    protected Map<String, BatchHandler> handlers;
    protected final AtomicInteger uploadInProgress = new AtomicInteger(0);

    public void activate(ComponentContext context) {
        super.activate(context);
        this.handlers = new HashMap<String, BatchHandler>();
    }

    public void deactivate(ComponentContext context) {
        this.handlers = null;
        super.deactivate(context);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (EP_BATCH_HANDLER.equals(extensionPoint)) {
            if (!(contribution instanceof BatchHandlerDescriptor)) {
                throw new NuxeoException("Invalid class: " + contribution.getClass().getName());
            }
        } else {
            throw new NuxeoException("Invalid extension point: " + extensionPoint);
        }
        BatchHandlerDescriptor contributionDescriptor = (BatchHandlerDescriptor)contribution;
        String name = contributionDescriptor.getName();
        BatchHandler batchHandler = contributionDescriptor.newInstance();
        batchHandler.initialize(name, contributionDescriptor.getProperties());
        this.handlers.put(name, batchHandler);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (EP_BATCH_HANDLER.equals(extensionPoint) && BatchHandlerDescriptor.class.isAssignableFrom(contribution.getClass())) {
            BatchHandlerDescriptor contributionDescriptor = (BatchHandlerDescriptor)contribution;
            String name = contributionDescriptor.getName();
            this.handlers.remove(name);
        }
    }

    @Override
    public TransientStore getTransientStore() {
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        return tss.getStore(TRANSIENT_STORE_NAME);
    }

    @Override
    public Set<String> getSupportedHandlers() {
        return Collections.unmodifiableSet(this.handlers.keySet());
    }

    @Override
    public BatchHandler getHandler(String handlerName) {
        return this.handlers.get(handlerName);
    }

    @Override
    public String initBatch() {
        Batch batch = this.initBatchInternal(null);
        return batch.getKey();
    }

    @Override
    @Deprecated
    public String initBatch(String batchId, String contextName) {
        Batch batch = this.initBatchInternal(batchId);
        return batch.getKey();
    }

    protected Batch initBatchInternal(String batchId) {
        BatchHandler batchHandler = this.handlers.get(DEFAULT_BATCH_HANDLER);
        return batchHandler.newBatch(batchId);
    }

    @Override
    public Batch initBatch(String handlerName) {
        BatchHandler batchHandler;
        if (StringUtils.isEmpty((CharSequence)handlerName)) {
            handlerName = DEFAULT_BATCH_HANDLER;
        }
        if ((batchHandler = this.handlers.get(handlerName)) == null) {
            throw new IllegalArgumentException("Batch handler does not exist: " + handlerName);
        }
        return batchHandler.newBatch(null);
    }

    @Override
    public Batch getBatch(String batchId) {
        return this.handlers.values().stream().map(batchHandler -> batchHandler.getBatch(batchId)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public void addStream(String batchId, String index, InputStream is, String name, String mime) throws IOException {
        Blob blob = Blobs.createBlob((InputStream)is);
        this.addBlob(batchId, index, blob, name, mime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBlob(String batchId, String index, Blob blob, String name, String mime) throws IOException {
        this.uploadInProgress.incrementAndGet();
        try {
            Batch batch = this.getBatch(batchId);
            if (batch == null) {
                batch = this.initBatchInternal(batchId);
            }
            batch.addFile(index, blob, name, mime);
            log.debug((Object)String.format("Added file %s [%s] to batch %s", index, name, batch.getKey()));
        }
        finally {
            this.uploadInProgress.decrementAndGet();
        }
    }

    @Override
    public void addStream(String batchId, String index, InputStream is, int chunkCount, int chunkIndex, String name, String mime, long fileSize) throws IOException {
        Blob blob = Blobs.createBlob((InputStream)is);
        this.addBlob(batchId, index, blob, chunkCount, chunkIndex, name, mime, fileSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBlob(String batchId, String index, Blob blob, int chunkCount, int chunkIndex, String name, String mime, long fileSize) throws IOException {
        this.uploadInProgress.incrementAndGet();
        try {
            Batch batch = this.getBatch(batchId);
            if (batch == null) {
                batch = this.initBatchInternal(batchId);
            }
            batch.addChunk(index, blob, chunkCount, chunkIndex, name, mime, fileSize);
            log.debug((Object)String.format("Added chunk %s to file %s [%s] in batch %s", chunkIndex, index, name, batch.getKey()));
        }
        finally {
            this.uploadInProgress.decrementAndGet();
        }
    }

    @Override
    public boolean hasBatch(String batchId) {
        return this.handlers.values().stream().anyMatch(batchHandler -> batchHandler.getBatch(batchId) != null);
    }

    @Override
    public List<Blob> getBlobs(String batchId) {
        return this.getBlobs(batchId, 0);
    }

    @Override
    public List<Blob> getBlobs(String batchId, int timeoutS) {
        Batch batch;
        if (this.uploadInProgress.get() > 0 && timeoutS > 0) {
            for (int i = 0; i < timeoutS * 5; ++i) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (this.uploadInProgress.get() == 0) break;
            }
        }
        if ((batch = this.getBatch(batchId)) == null) {
            log.error((Object)("Unable to find batch with id " + batchId));
            return Collections.emptyList();
        }
        return batch.getBlobs();
    }

    @Override
    public Blob getBlob(String batchId, String fileIndex) {
        return this.getBlob(batchId, fileIndex, 0);
    }

    @Override
    public Blob getBlob(String batchId, String fileIndex, int timeoutS) {
        Blob blob = this.getBatchBlob(batchId, fileIndex);
        if (blob == null && timeoutS > 0 && this.uploadInProgress.get() > 0) {
            for (int i = 0; i < timeoutS * 5; ++i) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                blob = this.getBatchBlob(batchId, fileIndex);
                if (blob != null) break;
            }
        }
        if (!this.hasBatch(batchId)) {
            log.error((Object)("Unable to find batch with id " + batchId));
            return null;
        }
        return blob;
    }

    protected Blob getBatchBlob(String batchId, String fileIndex) {
        Blob blob = null;
        Batch batch = this.getBatch(batchId);
        if (batch != null) {
            blob = batch.getBlob(fileIndex);
        }
        return blob;
    }

    @Override
    public List<BatchFileEntry> getFileEntries(String batchId) {
        Batch batch = this.getBatch(batchId);
        if (batch == null) {
            return null;
        }
        return batch.getFileEntries();
    }

    @Override
    public BatchFileEntry getFileEntry(String batchId, String fileIndex) {
        Batch batch = this.getBatch(batchId);
        if (batch == null) {
            return null;
        }
        return batch.getFileEntry(fileIndex);
    }

    @Override
    public void clean(String batchId) {
        Batch batch = this.getBatch(batchId);
        if (batch != null) {
            batch.clean();
        }
    }

    @Override
    public Object execute(String batchId, String chainOrOperationId, CoreSession session, Map<String, Object> contextParams, Map<String, Object> operationParams) {
        List<Blob> blobs = this.getBlobs(batchId, this.getUploadWaitTimeout());
        if (blobs == null) {
            String message = String.format("Unable to find batch associated with id '%s'", batchId);
            log.error((Object)message);
            throw new NuxeoException(message);
        }
        return this.execute(new BlobList(blobs), chainOrOperationId, session, contextParams, operationParams);
    }

    @Override
    public Object execute(String batchId, String fileIndex, String chainOrOperationId, CoreSession session, Map<String, Object> contextParams, Map<String, Object> operationParams) {
        Blob blob = this.getBlob(batchId, fileIndex, this.getUploadWaitTimeout());
        if (blob == null) {
            String message = String.format("Unable to find batch associated with id '%s' or file associated with index '%s'", batchId, fileIndex);
            log.error((Object)message);
            throw new NuxeoException(message);
        }
        return this.execute(blob, chainOrOperationId, session, contextParams, operationParams);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object execute(Object blobInput, String chainOrOperationId, CoreSession session, Map<String, Object> contextParams, Map<String, Object> operationParams) {
        if (contextParams == null) {
            contextParams = new HashMap<String, Object>();
        }
        if (operationParams == null) {
            operationParams = new HashMap<String, Object>();
        }
        try (OperationContext ctx = new OperationContext(session);){
            Principal principal;
            AutomationServer server = (AutomationServer)Framework.getService(AutomationServer.class);
            RestBinding binding = server.getOperationBinding(chainOrOperationId);
            if (!(binding == null || !binding.isAdministrator() || (principal = ctx.getPrincipal()) instanceof NuxeoPrincipal && ((NuxeoPrincipal)principal).isAdministrator())) {
                String message = "Not allowed. You must be administrator to use this operation";
                log.error((Object)message);
                throw new WebSecurityException(message);
            }
            ctx.setInput(blobInput);
            ctx.putAll(contextParams);
            AutomationService as = (AutomationService)Framework.getService(AutomationService.class);
            Object object = as.run(ctx, chainOrOperationId, operationParams);
            return object;
        }
        catch (OperationException e) {
            log.error((Object)"Error while executing automation batch ", (Throwable)e);
            throw new NuxeoException((Throwable)e);
        }
    }

    protected int getUploadWaitTimeout() {
        String t = Framework.getProperty((String)"org.nuxeo.batch.upload.wait.timeout", (String)"5");
        try {
            return Integer.parseInt(t);
        }
        catch (NumberFormatException e) {
            log.error((Object)"Wrong number format for upload wait timeout property", (Throwable)e);
            return 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeAndClean(String batchId, String chainOrOperationId, CoreSession session, Map<String, Object> contextParams, Map<String, Object> operationParams) {
        try {
            Object object = this.execute(batchId, chainOrOperationId, session, contextParams, operationParams);
            return object;
        }
        finally {
            this.clean(batchId);
        }
    }

    @Override
    public boolean removeFileEntry(String batchId, String filedIdx) {
        Batch batch = this.getBatch(batchId);
        return batch != null && batch.removeFileEntry(filedIdx);
    }

    static {
        ComplexTypeJSONDecoder.registerBlobDecoder((JSONBlobDecoder)new JSONBatchBlobDecoder());
    }
}

