/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.batch.handler;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.server.jaxrs.batch.Batch;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchHandler;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public abstract class AbstractBatchHandler
implements BatchHandler {
    private static final Log log = LogFactory.getLog(AbstractBatchHandler.class);
    public static final String PROP_TRANSIENT_STORE_NAME = "transientStore";
    public static final String BATCH_HANDLER_NAME = "handler";
    protected String name;
    protected String transientStoreName;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void initialize(String name, Map<String, String> properties) {
        this.name = name;
        this.initialize(properties);
    }

    protected void initialize(Map<String, String> properties) {
        if (StringUtils.isEmpty((CharSequence)properties.get(PROP_TRANSIENT_STORE_NAME))) {
            throw new NuxeoException("Missing configuration property: transientStore");
        }
        this.transientStoreName = properties.get(PROP_TRANSIENT_STORE_NAME);
    }

    protected TransientStore getTransientStore() {
        return ((TransientStoreService)Framework.getService(TransientStoreService.class)).getStore(this.transientStoreName);
    }

    protected Map<String, Serializable> getBatchParameters(String batchId) {
        String handlerName;
        TransientStore transientStore = this.getTransientStore();
        HashMap parameters = transientStore.getParameters(batchId);
        if (parameters == null) {
            if (StringUtils.isEmpty((CharSequence)batchId) || !transientStore.exists(batchId)) {
                return null;
            }
            parameters = new HashMap();
        }
        if ((handlerName = (String)parameters.remove(BATCH_HANDLER_NAME)) != null && !handlerName.equals(this.getName())) {
            return null;
        }
        return parameters;
    }

    @Override
    public Batch newBatch(String batchId) {
        TransientStore transientStore = this.getTransientStore();
        if (StringUtils.isEmpty((CharSequence)batchId)) {
            batchId = this.generateBatchId();
        } else if (!((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanPropertyTrue("allowClientGeneratedBatchId")) {
            throw new NuxeoException(String.format("Cannot initialize upload batch with a given id since configuration property %s is not set to true", "allowClientGeneratedBatchId"));
        }
        log.debug((Object)("Initializing batch with id: " + batchId));
        transientStore.setCompleted(batchId, false);
        transientStore.putParameter(batchId, BATCH_HANDLER_NAME, (Serializable)((Object)this.getName()));
        return new Batch(batchId);
    }

    protected String generateBatchId() {
        return "batchId-" + UUID.randomUUID();
    }
}

