/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.jms;

import java.io.Serializable;
import java.rmi.dgc.VMID;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.SimplePrincipal;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventBundleImpl;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.event.impl.EventImpl;

public class SerializableEventBundle
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SerializableEventBundle.class);
    protected final List<Map<String, Serializable>> serialisableEvents;
    protected final String eventBundleName;
    protected final VMID sourceVMID;
    protected boolean isDocumentEventContext = false;
    protected String coreInstanceName;

    public SerializableEventBundle(EventBundle events) {
        this.eventBundleName = events.getName();
        this.sourceVMID = events.getSourceVMID();
        this.serialisableEvents = new ArrayList<Map<String, Serializable>>();
        for (Event event : events) {
            if (event.isLocal()) continue;
            CoreSession evtSession = event.getContext().getCoreSession();
            String repoName = null;
            if (evtSession != null) {
                repoName = evtSession.getRepositoryName();
                if (this.coreInstanceName == null) {
                    this.coreInstanceName = repoName;
                }
            }
            HashMap<String, Object> serializableEvent = new HashMap<String, Object>();
            serializableEvent.put("name", event.getName());
            serializableEvent.put("time", Long.toString(event.getTime()));
            serializableEvent.put("contextProperties", (Serializable)((Object)event.getContext().getProperties()));
            if (evtSession != null) {
                serializableEvent.put("contextSessionId", evtSession.getSessionId());
            }
            serializableEvent.put("principal", event.getContext().getPrincipal().getName());
            serializableEvent.put("contextSessionRepositoryName", repoName);
            if (event.getContext() instanceof DocumentEventContext) {
                serializableEvent.put("isDocumentEventContext", true);
            } else {
                serializableEvent.put("isDocumentEventContext", false);
            }
            Object[] args = event.getContext().getArguments();
            ArrayList<Object> listArgs = new ArrayList<Object>();
            for (Object arg : args) {
                if (arg instanceof DocumentModel) {
                    DocumentModel doc = (DocumentModel)arg;
                    String strRepresentation = doc.getRepositoryName() + ":" + doc.getId() + ":" + doc.getType() + ":" + doc.getPathAsString();
                    listArgs.add("DOCREF:" + strRepresentation);
                    continue;
                }
                if (arg instanceof Serializable) {
                    log.debug((Object)("Adding serializable argument of class " + arg.getClass().getCanonicalName()));
                    listArgs.add((Serializable)arg);
                    continue;
                }
                listArgs.add(null);
            }
            serializableEvent.put("args", listArgs);
            this.serialisableEvents.add(serializableEvent);
        }
    }

    protected Map<String, Serializable> filterContextProperties(Map<String, Serializable> properties) {
        HashMap<String, Serializable> serializableProps = new HashMap<String, Serializable>();
        for (String key : properties.keySet()) {
            Serializable value = properties.get(key);
            if (value instanceof Serializable) {
                Serializable serializableValue = value;
                serializableProps.put(key, serializableValue);
                continue;
            }
            log.error((Object)("ContextMap contains non serializable object under key " + key));
        }
        return serializableProps;
    }

    public VMID getSourceVMID() {
        return this.sourceVMID;
    }

    public String getEventBundleName() {
        return this.eventBundleName;
    }

    public String getCoreInstanceName() {
        return this.coreInstanceName;
    }

    public EventBundle reconstructEventBundle(CoreSession session) throws CannotReconstruct {
        if (!session.getRepositoryName().equals(this.coreInstanceName)) {
            throw new CannotReconstruct("This session can not be used on this Bundle");
        }
        EventBundleRelayedViaJMS bundle = new EventBundleRelayedViaJMS();
        if (this.serialisableEvents == null) {
            return null;
        }
        for (Map<String, Serializable> evt : this.serialisableEvents) {
            EventContextImpl ctx;
            String eventName = (String)((Object)evt.get("name"));
            Long time = Long.parseLong((String)((Object)evt.get("time")));
            Map ctxProperties = (Map)((Object)evt.get("contextProperties"));
            SimplePrincipal principal = new SimplePrincipal((String)((Object)evt.get("principal")));
            List listArgs = (List)((Object)evt.get("args"));
            Object[] args = new Object[listArgs.size()];
            int idx = 0;
            for (Serializable sArg : listArgs) {
                Object value;
                if (sArg == null) {
                    value = null;
                } else if (sArg instanceof String) {
                    String arg = (String)((Object)sArg);
                    if (arg.startsWith("DOCREF:")) {
                        String[] part = arg.split(":");
                        IdRef idRef = new IdRef(part[2]);
                        DocumentModel doc = null;
                        if (session.exists((DocumentRef)idRef)) {
                            doc = session.getDocument((DocumentRef)idRef);
                        } else {
                            String parentPath = new Path(part[4]).removeLastSegments(1).toString();
                            doc = new DocumentModelImpl(session.getSessionId(), part[3], part[2], new Path(part[4]), null, (DocumentRef)idRef, (DocumentRef)new PathRef(parentPath), null, null, null, null);
                        }
                        value = doc;
                    } else {
                        value = arg;
                    }
                } else {
                    value = sArg;
                }
                args[idx] = value;
                ++idx;
            }
            if (((Boolean)evt.get("isDocumentEventContext")).booleanValue()) {
                ctx = new DocumentEventContext(session, (Principal)principal, (DocumentModel)args[0], (DocumentRef)args[1]);
            } else {
                ctx = new EventContextImpl(session, (Principal)principal);
                ctx.setArgs(args);
            }
            ctx.setProperties(ctxProperties);
            EventImpl e = new EventImpl(eventName, ctx, 0, time);
            bundle.push(e);
        }
        return bundle;
    }

    public static class CannotReconstruct
    extends NuxeoException {
        private static final long serialVersionUID = 1L;

        public CannotReconstruct(String message) {
            super(message);
        }
    }

    public class EventBundleRelayedViaJMS
    extends EventBundleImpl {
        private static final long serialVersionUID = 1L;

        public EventBundleRelayedViaJMS() {
            super(SerializableEventBundle.this.sourceVMID);
        }
    }
}

