/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.nuxeo.ecm.core.work.MemoryBlockingQueue;
import org.nuxeo.ecm.core.work.WorkQueuing;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkQueueDescriptor;
import org.nuxeo.ecm.core.work.api.WorkQueueMetrics;

public class MemoryWorkQueuing
implements WorkQueuing {
    protected final Map<String, MemoryBlockingQueue> allQueued = new HashMap<String, MemoryBlockingQueue>();
    protected WorkQueuing.Listener listener;

    public MemoryWorkQueuing(WorkQueuing.Listener listener) {
        this.listener = listener;
    }

    @Override
    public MemoryBlockingQueue init(WorkQueueDescriptor config) {
        int capacity = config.getCapacity();
        if (capacity <= 0) {
            capacity = -1;
        }
        MemoryBlockingQueue queue = new MemoryBlockingQueue(config.id, this, capacity);
        this.allQueued.put(queue.queueId, queue);
        return queue;
    }

    @Override
    public MemoryBlockingQueue getQueue(String queueId) {
        return this.allQueued.get(queueId);
    }

    @Override
    public void workSchedule(String queueId, Work work) {
        this.listener.queueChanged(work, this.getQueue(queueId).workSchedule(work));
    }

    @Override
    public void workCanceled(String queueId, Work work) {
        this.listener.queueChanged(work, this.getQueue(queueId).workCanceled(work));
    }

    @Override
    public void workRunning(String queueId, Work work) {
        this.listener.queueChanged(work, this.getQueue(queueId).workRunning(work));
    }

    @Override
    public void workCompleted(String queueId, Work work) {
        this.listener.queueChanged(work, this.getQueue(queueId).workCompleted(work));
    }

    @Override
    public void workReschedule(String queueId, Work work) {
        this.listener.queueChanged(work, this.getQueue(queueId).workRescheduleRunning(work));
    }

    Optional<Work> lookup(String workId) {
        return this.allQueued.values().stream().map(queue -> queue.lookup(workId)).filter(Objects::nonNull).findAny();
    }

    @Override
    public Work find(String workId, Work.State state) {
        return this.lookup(workId).filter(work -> MemoryWorkQueuing.workHasState(work, state)).orElse(null);
    }

    @Override
    public boolean isWorkInState(String workId, Work.State state) {
        return this.lookup(workId).filter(work -> MemoryWorkQueuing.workHasState(work, state)).isPresent();
    }

    @Override
    public Work.State getWorkState(String workId) {
        return this.lookup(workId).map(Work::getWorkInstanceState).orElse(null);
    }

    @Override
    public List<Work> listWork(String queueId, Work.State state) {
        MemoryBlockingQueue queue = this.getQueue(queueId);
        if (state == null) {
            return queue.list();
        }
        switch (state) {
            case SCHEDULED: {
                return queue.listScheduled();
            }
            case RUNNING: {
                return queue.listRunning();
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)state));
    }

    @Override
    public List<String> listWorkIds(String queueId, Work.State state) {
        MemoryBlockingQueue queue = this.getQueue(queueId);
        if (state == null) {
            return queue.keys();
        }
        switch (state) {
            case SCHEDULED: {
                return queue.scheduledKeys();
            }
            case RUNNING: {
                return queue.runningKeys();
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)state));
    }

    @Override
    public long count(String queueId, Work.State state) {
        switch (state) {
            case SCHEDULED: {
                return this.metrics((String)queueId).scheduled.longValue();
            }
            case RUNNING: {
                return this.metrics((String)queueId).running.longValue();
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)state));
    }

    @Override
    public synchronized void removeScheduled(String queueId, String workId) {
        MemoryBlockingQueue queue = this.getQueue(queueId);
        Work work = queue.lookup(workId);
        if (work == null) {
            return;
        }
        work.setWorkInstanceState(Work.State.UNKNOWN);
        this.listener.queueChanged(work, queue.workCanceled(work));
    }

    @Override
    public void setActive(String queueId, boolean value) {
        WorkQueueMetrics metrics = this.getQueue(queueId).setActive(value);
        if (value) {
            this.listener.queueActivated(metrics);
        } else {
            this.listener.queueDeactivated(metrics);
        }
    }

    @Override
    public void listen(WorkQueuing.Listener listener) {
        this.listener = listener;
    }

    @Override
    public WorkQueueMetrics metrics(String queueId) {
        return this.getQueue(queueId).metrics();
    }

    protected static boolean workHasState(Work work, Work.State state) {
        Work.State workState = work.getWorkInstanceState();
        return state == null ? workState == Work.State.SCHEDULED || workState == Work.State.RUNNING : workState == state;
    }
}

